/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.TopicPartitionEntity;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class ActiveStandbyEntity {
    private final ImmutableSet<String> activeStores;
    private final ImmutableSet<TopicPartitionEntity> activePartitions;
    private final ImmutableSet<String> standByStores;
    private final ImmutableSet<TopicPartitionEntity> standByPartitions;

    @JsonCreator
    public ActiveStandbyEntity(@JsonProperty(value="activeStores") Set<String> activeStores, @JsonProperty(value="activePartitions") Set<TopicPartitionEntity> activePartitions, @JsonProperty(value="standByStores") Set<String> standByStores, @JsonProperty(value="standByPartitions") Set<TopicPartitionEntity> standByPartitions) {
        this.activeStores = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activeStores));
        this.activePartitions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activePartitions));
        this.standByStores = ImmutableSet.copyOf((Collection)Objects.requireNonNull(standByStores));
        this.standByPartitions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(standByPartitions));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="activeStores is ImmutableSet")
    public Set<String> getActiveStores() {
        return this.activeStores;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="standByStores is ImmutableSet")
    public Set<String> getStandByStores() {
        return this.standByStores;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="activePartitions is ImmutableSet")
    public Set<TopicPartitionEntity> getActivePartitions() {
        return this.activePartitions;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="standByPartitions is ImmutableSet")
    public Set<TopicPartitionEntity> getStandByPartitions() {
        return this.standByPartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveStandbyEntity that = (ActiveStandbyEntity)o;
        return Objects.equals(this.activeStores, that.activeStores) && Objects.equals(this.standByStores, that.standByStores) && Objects.equals(this.activePartitions, that.activePartitions) && Objects.equals(this.standByPartitions, that.standByPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.activeStores, this.standByStores, this.activePartitions, this.standByPartitions);
    }

    public String toString() {
        return "ActiveStandbyEntity{ Active stores = " + this.activeStores + ", Active partitions = " + this.activePartitions + ", Standby stores = " + this.standByStores + ", Standby partitions = " + this.standByPartitions + "}";
    }
}

