/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConsumerPartitionOffsets {
    private final int partition;
    private final long logStartOffset;
    private final long logEndOffset;
    private final long consumerOffset;

    @JsonCreator
    public ConsumerPartitionOffsets(@JsonProperty(value="partition") int partition, @JsonProperty(value="logStartOffset") long logStartOffset, @JsonProperty(value="logEndOffset") long logEndOffset, @JsonProperty(value="consumerOffset") long consumerOffset) {
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)("Invalid partition: " + partition));
        Preconditions.checkArgument((logStartOffset >= 0L ? 1 : 0) != 0, (Object)("Invalid start offset: " + logStartOffset));
        Preconditions.checkArgument((logEndOffset >= 0L ? 1 : 0) != 0, (Object)("Invalid end offset: " + logEndOffset));
        Preconditions.checkArgument((consumerOffset >= 0L ? 1 : 0) != 0, (Object)("Invalid consumer offset: " + logEndOffset));
        this.partition = partition;
        this.logStartOffset = logStartOffset;
        this.logEndOffset = logEndOffset;
        this.consumerOffset = consumerOffset;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getConsumerOffset() {
        return this.consumerOffset;
    }

    public long getLogStartOffset() {
        return this.logStartOffset;
    }

    public long getLogEndOffset() {
        return this.logEndOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerPartitionOffsets that = (ConsumerPartitionOffsets)o;
        return this.partition == that.partition && this.logStartOffset == that.logStartOffset && this.logEndOffset == that.logEndOffset && this.consumerOffset == that.consumerOffset;
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.logStartOffset, this.logEndOffset, this.consumerOffset);
    }
}

