/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.FieldInfo;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.KsqlPreconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaInfo {
    private final SqlBaseType type;
    private final ImmutableList<FieldInfo> fields;
    private final SchemaInfo memberSchema;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @EffectivelyImmutable
    private final ImmutableMap<String, Object> parameters;
    @EffectivelyImmutable
    private static final ImmutableMap<SqlBaseType, Function<SchemaInfo, String>> TO_TYPE_STRING = ImmutableMap.builder().put((Object)SqlBaseType.STRING, si -> "VARCHAR(STRING)").put((Object)SqlBaseType.ARRAY, si -> SqlBaseType.ARRAY + "<" + si.memberSchema.toTypeString() + ">").put((Object)SqlBaseType.MAP, si -> SqlBaseType.MAP + "<" + SqlBaseType.STRING + ", " + si.memberSchema.toTypeString() + ">").put((Object)SqlBaseType.STRUCT, si -> si.fields.stream().map(f -> f.getName() + " " + f.getSchema().toTypeString()).collect(Collectors.joining(", ", SqlBaseType.STRUCT + "<", ">"))).put((Object)SqlBaseType.DECIMAL, si -> {
        if (si.getParameters().isEmpty()) {
            return String.valueOf(SqlBaseType.DECIMAL);
        }
        Object precision = si.getParameters().get((Object)"precision");
        Object scale = si.getParameters().get((Object)"scale");
        String parameterString = String.format("(%s, %s)", precision, scale);
        KsqlPreconditions.checkArgument((boolean)(precision != null & scale != null), (String)("Either one of precision and scale missing: " + parameterString));
        return SqlBaseType.DECIMAL + parameterString;
    }).build();

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="parameters is ImmutableMap")
    public SchemaInfo(@JsonProperty(value="type") SqlBaseType type, @JsonProperty(value="fields") List<? extends FieldInfo> fields, @JsonProperty(value="memberSchema") SchemaInfo memberSchema, @JsonProperty(value="parameters") ImmutableMap<String, Object> parameters) {
        Objects.requireNonNull(type);
        this.type = type;
        this.fields = fields == null ? null : ImmutableList.copyOf(fields);
        this.memberSchema = memberSchema;
        this.parameters = parameters;
    }

    public SchemaInfo(@JsonProperty(value="type") SqlBaseType type, @JsonProperty(value="fields") List<? extends FieldInfo> fields, @JsonProperty(value="memberSchema") SchemaInfo memberSchema) {
        this(type, fields, memberSchema, (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public SqlBaseType getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public String getTypeName() {
        return this.type.name();
    }

    public Optional<List<FieldInfo>> getFields() {
        return Optional.ofNullable(this.fields);
    }

    public Optional<SchemaInfo> getMemberSchema() {
        return Optional.ofNullable(this.memberSchema);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="parameters is ImmutableMap")
    public ImmutableMap<String, Object> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaInfo that = (SchemaInfo)o;
        return this.type == that.type && Objects.equals(this.fields, that.fields) && Objects.equals(this.memberSchema, that.memberSchema);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.fields, this.memberSchema);
    }

    public String toTypeString() {
        return (String)((Function)TO_TYPE_STRING.getOrDefault((Object)this.type, si -> si.type.name())).apply(this);
    }
}

