/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.LagInfoEntity;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class StateStoreLags {
    private final ImmutableMap<Integer, LagInfoEntity> lagByPartition;

    @JsonCreator
    public StateStoreLags(@JsonProperty(value="lagByPartition") Map<Integer, LagInfoEntity> lagByPartition) {
        this.lagByPartition = ImmutableMap.copyOf(Objects.requireNonNull(lagByPartition, "lagByPartition"));
    }

    public Optional<LagInfoEntity> getLagByPartition(int partition) {
        return Optional.ofNullable(this.lagByPartition.get((Object)partition));
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="lagByPartition is ImmutableMap")
    public Map<Integer, LagInfoEntity> getLagByPartition() {
        return this.lagByPartition;
    }

    public int getSize() {
        return this.lagByPartition.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateStoreLags that = (StateStoreLags)o;
        return Objects.equals(this.lagByPartition, that.lagByPartition);
    }

    public int hashCode() {
        return Objects.hash(this.lagByPartition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lagByPartition", this.lagByPartition).toString();
    }
}

