/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.KsqlHostInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SessionProperties {
    private final Map<String, Object> mutableScopedProperties;
    private final KsqlHostInfo ksqlHostInfo;
    private final URL localUrl;
    private final boolean internalRequest;
    private final Map<String, String> sessionVariables;

    public SessionProperties(Map<String, Object> mutableScopedProperties, KsqlHostInfo ksqlHostInfo, URL localUrl, boolean internalRequest, Map<String, Object> sessionVariables) {
        this.mutableScopedProperties = new HashMap<String, Object>(Objects.requireNonNull(mutableScopedProperties, "mutableScopedProperties"));
        this.ksqlHostInfo = Objects.requireNonNull(ksqlHostInfo, "ksqlHostInfo");
        this.localUrl = Objects.requireNonNull(localUrl, "localUrl");
        this.internalRequest = internalRequest;
        this.sessionVariables = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.sessionVariables.putAll(Objects.requireNonNull(sessionVariables, "sessionVariables").entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString())));
    }

    public SessionProperties(Map<String, Object> mutableScopedProperties, KsqlHostInfo ksqlHostInfo, URL localUrl, boolean internalRequest) {
        this(mutableScopedProperties, ksqlHostInfo, localUrl, internalRequest, Collections.emptyMap());
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="should be mutable")
    public Map<String, Object> getMutableScopedProperties() {
        return this.mutableScopedProperties;
    }

    public KsqlHostInfo getKsqlHostInfo() {
        return this.ksqlHostInfo;
    }

    public URL getLocalUrl() {
        try {
            return new URL(this.localUrl.toString());
        }
        catch (MalformedURLException fatalError) {
            throw new IllegalStateException("Could not deep copy URL: " + this.localUrl);
        }
    }

    public boolean getInternalRequest() {
        return this.internalRequest;
    }

    public Map<String, String> getSessionVariables() {
        return Collections.unmodifiableMap(this.sessionVariables);
    }

    public void setVariable(String name, String value) {
        this.sessionVariables.put(name, value);
    }

    public void unsetVariable(String name) {
        this.sessionVariables.remove(name);
    }
}

