/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.ConsumerPartitionOffsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class QueryTopicOffsetSummary {
    private final String kafkaTopic;
    private final List<ConsumerPartitionOffsets> offsets;

    @JsonCreator
    public QueryTopicOffsetSummary(@JsonProperty(value="kafkaTopic") String kafkaTopic, @JsonProperty(value="offsets") List<ConsumerPartitionOffsets> offsets) {
        this.kafkaTopic = Objects.requireNonNull(kafkaTopic, "kafkaTopic");
        this.offsets = ImmutableList.copyOf((Collection)Objects.requireNonNull(offsets, "offsets"));
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="offsets is ImmutableList")
    public List<ConsumerPartitionOffsets> getOffsets() {
        return this.offsets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryTopicOffsetSummary that = (QueryTopicOffsetSummary)o;
        return Objects.equals(this.kafkaTopic, that.kafkaTopic) && Objects.equals(this.offsets, that.offsets);
    }

    public int hashCode() {
        return Objects.hash(this.kafkaTopic, this.offsets);
    }
}

