/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.rest.entity.ConnectorType;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public class SimpleConnectorInfo {
    private final String name;
    private final ConnectorType type;
    private final String className;
    private final String state;

    @JsonCreator
    public SimpleConnectorInfo(@JsonProperty(value="name") String name, @JsonProperty(value="type") ConnectorType type, @JsonProperty(value="className") String className, @JsonProperty(value="state") String state) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = type;
        this.className = className;
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public ConnectorType getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public String getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleConnectorInfo that = (SimpleConnectorInfo)o;
        return Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.className, that.className) && Objects.equals(this.state, that.state);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.className, this.state});
    }

    public String toString() {
        return "SimpleConnectorInfo{name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + ", className='" + this.className + '\'' + ", state=" + this.state + '}';
    }
}

