/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.rest.entity.ConnectorType;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ConnectorStateInfo {
    public static final String RUNNING = "RUNNING";
    private final String name;
    private final ConnectorState connector;
    private final ImmutableList<TaskState> tasks;
    private final ConnectorType type;

    @JsonCreator
    public ConnectorStateInfo(@JsonProperty(value="name") String name, @JsonProperty(value="connector") ConnectorState connector, @JsonProperty(value="tasks") List<TaskState> tasks, @JsonProperty(value="type") ConnectorType type) {
        this.name = name;
        this.connector = connector;
        this.tasks = ImmutableList.copyOf(tasks);
        this.type = type;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public ConnectorState connector() {
        return this.connector;
    }

    @JsonProperty
    public List<TaskState> tasks() {
        return this.tasks;
    }

    @JsonProperty
    public ConnectorType type() {
        return this.type;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConnectorState
    extends AbstractState {
        @JsonCreator
        public ConnectorState(@JsonProperty(value="state") String state, @JsonProperty(value="worker_id") String worker, @JsonProperty(value="msg") String msg) {
            super(state, worker, msg);
        }
    }

    public static abstract class AbstractState {
        private final String state;
        private final String trace;
        private final String workerId;

        public AbstractState(String state, String workerId, String trace) {
            this.state = state;
            this.workerId = workerId;
            this.trace = trace;
        }

        @JsonProperty
        public String state() {
            return this.state;
        }

        @JsonProperty(value="worker_id")
        public String workerId() {
            return this.workerId;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public String trace() {
            return this.trace;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TaskState
    extends AbstractState
    implements Comparable<TaskState> {
        private final int id;

        @JsonCreator
        public TaskState(@JsonProperty(value="id") int id, @JsonProperty(value="state") String state, @JsonProperty(value="worker_id") String worker, @JsonProperty(value="msg") String msg) {
            super(state, worker, msg);
            this.id = id;
        }

        @JsonProperty
        public int id() {
            return this.id;
        }

        @Override
        public int compareTo(TaskState that) {
            return Integer.compare(this.id, that.id);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskState)) {
                return false;
            }
            TaskState other = (TaskState)o;
            return this.compareTo(other) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

