/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.ActiveStandbyEntity;
import io.confluent.ksql.rest.entity.HostStoreLags;
import java.util.Map;
import java.util.Objects;

@Immutable
@JsonIgnoreProperties(ignoreUnknown=true)
public class HostStatusEntity {
    private final boolean hostAlive;
    private final long lastStatusUpdateMs;
    private final ImmutableMap<String, ActiveStandbyEntity> activeStandbyPerQuery;
    private final HostStoreLags hostStoreLags;

    @JsonCreator
    public HostStatusEntity(@JsonProperty(value="hostAlive") boolean hostAlive, @JsonProperty(value="lastStatusUpdateMs") long lastStatusUpdateMs, @JsonProperty(value="activeStandbyPerQuery") Map<String, ActiveStandbyEntity> activeStandbyPerQuery, @JsonProperty(value="hostStoreLags") HostStoreLags hostStoreLags) {
        this.hostAlive = hostAlive;
        this.lastStatusUpdateMs = lastStatusUpdateMs;
        this.activeStandbyPerQuery = ImmutableMap.copyOf(Objects.requireNonNull(activeStandbyPerQuery, "activeStandbyPerQuery"));
        this.hostStoreLags = Objects.requireNonNull(hostStoreLags, "hostStoreLags");
    }

    public boolean getHostAlive() {
        return this.hostAlive;
    }

    public long getLastStatusUpdateMs() {
        return this.lastStatusUpdateMs;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="activeStandbyPerQuery is ImmutableMap")
    public ImmutableMap<String, ActiveStandbyEntity> getActiveStandbyPerQuery() {
        return this.activeStandbyPerQuery;
    }

    public HostStoreLags getHostStoreLags() {
        return this.hostStoreLags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostStatusEntity that = (HostStatusEntity)o;
        return this.hostAlive == that.hostAlive && this.lastStatusUpdateMs == that.lastStatusUpdateMs && Objects.equals(this.activeStandbyPerQuery, that.activeStandbyPerQuery) && Objects.equals(this.hostStoreLags, that.hostStoreLags);
    }

    public int hashCode() {
        return Objects.hash(this.hostAlive, this.lastStatusUpdateMs, this.activeStandbyPerQuery, this.hostStoreLags);
    }

    public String toString() {
        return "HostStatusEntity{hostAlive=" + this.hostAlive + ", lastStatusUpdateMs=" + this.lastStatusUpdateMs + ", activeStandbyPerQuery=" + String.valueOf(this.activeStandbyPerQuery) + ", hostStoreLags=" + String.valueOf(this.hostStoreLags) + "}";
    }
}

