/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.util.ErrorMessageUtil;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KsqlStatementErrorMessage
extends KsqlErrorMessage {
    private final String statementText;
    private final KsqlEntityList entities;

    public KsqlStatementErrorMessage(@JsonProperty(value="error_code") int errorCode, @JsonProperty(value="message") String message, @JsonProperty(value="statementText") String statementText, @JsonProperty(value="entities") KsqlEntityList entities) {
        super(errorCode, message);
        this.entities = new KsqlEntityList(entities);
        this.statementText = statementText;
    }

    public KsqlStatementErrorMessage(int errorCode, Throwable t, String statementText, KsqlEntityList entityList) {
        this(errorCode, ErrorMessageUtil.buildErrorMessage((Throwable)t), statementText, entityList);
    }

    public String getStatementText() {
        return this.statementText;
    }

    public KsqlEntityList getEntities() {
        return new KsqlEntityList(this.entities);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KsqlStatementErrorMessage that = (KsqlStatementErrorMessage)o;
        return Objects.equals(this.statementText, that.statementText) && Objects.equals(this.entities, that.entities) && Objects.equals(this.getMessage(), that.getMessage()) && Objects.equals(this.getErrorCode(), that.getErrorCode());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.statementText, this.entities);
    }
}

