/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.errorprone.annotations.Immutable;
import java.util.Locale;
import java.util.Objects;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public class SimpleConnectorPluginInfo {
    @JsonAlias(value={"class"})
    private final String className;
    private final PluginType type;
    private final String version;

    @JsonCreator
    public SimpleConnectorPluginInfo(@JsonProperty(value="className") String className, @JsonProperty(value="type") PluginType type, @JsonProperty(value="version") String version) {
        this.className = Objects.requireNonNull(className, "className");
        this.type = type;
        this.version = version;
    }

    public String getClassName() {
        return this.className;
    }

    public PluginType getType() {
        return this.type;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleConnectorPluginInfo that = (SimpleConnectorPluginInfo)o;
        return Objects.equals(this.className, that.className) && this.type == that.type && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.className, this.type, this.version});
    }

    public String toString() {
        return "SimpleConnectorPluginInfo{className='" + this.className + "', type=" + String.valueOf((Object)this.type) + ", version='" + this.version + "'}";
    }

    public static enum PluginType {
        SOURCE(SourceConnector.class),
        SINK(SinkConnector.class),
        CONVERTER(Converter.class),
        HEADER_CONVERTER(HeaderConverter.class),
        TRANSFORMATION(Transformation.class),
        PREDICATE(Predicate.class),
        CONFIGPROVIDER(ConfigProvider.class),
        REST_EXTENSION(ConnectRestExtension.class),
        CONNECTOR_CLIENT_CONFIG_OVERRIDE_POLICY(ConnectorClientConfigOverridePolicy.class),
        UNKNOWN(Object.class);

        private final Class<?> klass;

        private PluginType(Class<?> klass) {
            this.klass = klass;
        }

        public static PluginType from(Class<?> klass) {
            for (PluginType type : PluginType.values()) {
                if (!type.klass.isAssignableFrom(klass)) continue;
                return type;
            }
            return UNKNOWN;
        }

        public String simpleName() {
            return this.klass.getSimpleName();
        }

        @JsonValue
        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

