/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="STREAM", value=Stream.class), @JsonSubTypes.Type(name="TABLE", value=Table.class)})
public abstract class SourceInfo {
    private final String name;
    private final String topic;
    private final String keyFormat;
    private final String valueFormat;
    private final boolean windowed;

    SourceInfo(String name, String topic, String keyFormat, String valueFormat, boolean windowed) {
        this.name = Objects.requireNonNull(name, "name");
        this.topic = Objects.requireNonNull(topic, "topic");
        this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
        this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        this.windowed = windowed;
    }

    public String getName() {
        return this.name;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    @JsonProperty(value="isWindowed")
    public boolean isWindowed() {
        return this.windowed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceInfo that = (SourceInfo)o;
        return this.windowed == that.windowed && Objects.equals(this.name, that.name) && Objects.equals(this.topic, that.topic) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.valueFormat, that.valueFormat);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.topic, this.keyFormat, this.valueFormat, this.windowed);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Table
    extends SourceInfo {
        @Deprecated
        @JsonCreator
        public Table(@JsonProperty(value="name") String name, @JsonProperty(value="topic") String topic, @JsonProperty(value="keyFormat") Optional<String> keyFormat, @JsonProperty(value="valueFormat") Optional<String> valueFormat, @JsonProperty(value="isWindowed") Optional<Boolean> windowed, @JsonProperty(value="format") Optional<String> legacyValueFormat) {
            this(name, topic, keyFormat.orElse("KAFKA"), valueFormat.orElse(legacyValueFormat.orElse("UNKNOWN")), windowed.orElse(false));
        }

        public Table(String name, String topic, String keyFormat, String valueFormat, boolean windowed) {
            super(name, topic, keyFormat, valueFormat, windowed);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Stream
    extends SourceInfo {
        @Deprecated
        @JsonCreator
        public Stream(@JsonProperty(value="name") String name, @JsonProperty(value="topic") String topic, @JsonProperty(value="keyFormat") Optional<String> keyFormat, @JsonProperty(value="valueFormat") Optional<String> valueFormat, @JsonProperty(value="isWindowed") Optional<Boolean> windowed, @JsonProperty(value="format") Optional<String> legacyValueFormat) {
            this(name, topic, keyFormat.orElse("KAFKA"), valueFormat.orElse(legacyValueFormat.orElse("UNKNOWN")), windowed.orElse(false));
        }

        public Stream(String name, String topic, String keyFormat, String valueFormat, boolean windowed) {
            super(name, topic, keyFormat, valueFormat, windowed);
        }
    }
}

