/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.entity.KsqlEntity;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class VariablesList
extends KsqlEntity {
    private final List<Variable> variables;

    @JsonCreator
    public VariablesList(@JsonProperty(value="statementText") String statementText, @JsonProperty(value="variables") List<Variable> variables) {
        super(statementText);
        this.variables = variables == null ? ImmutableList.of() : ImmutableList.copyOf(variables);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="variables is ImmutableList")
    public List<Variable> getVariables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        return o instanceof VariablesList && Objects.equals(this.variables, ((VariablesList)o).variables);
    }

    public int hashCode() {
        return Objects.hash(this.variables);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Variable {
        private final String name;
        private final String value;

        @JsonCreator
        public Variable(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Variable that = (Variable)object;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }

        public String toString() {
            return "Variable{name='" + this.name + "', value='" + this.value + "'}";
        }
    }
}

