/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.base.Preconditions;
import io.confluent.ksql.serde.SerdeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;

class GenericDeserializer<T>
implements Deserializer<T> {
    private final Function<List<?>, T> factory;
    private final Deserializer<List<?>> inner;
    private final int numColumns;

    GenericDeserializer(Function<List<?>, T> factory, Deserializer<List<?>> inner, int expectedNumColumns) {
        this.inner = Objects.requireNonNull(inner, "inner");
        this.factory = Objects.requireNonNull(factory, "factory");
        this.numColumns = expectedNumColumns;
        Preconditions.checkArgument((expectedNumColumns >= 0 ? 1 : 0) != 0, (Object)("negative expected column count: " + expectedNumColumns));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.inner.configure(configs, isKey);
    }

    public void close() {
        this.inner.close();
    }

    public T deserialize(String topic, byte[] data) {
        List values = (List)this.inner.deserialize(topic, data);
        if (values == null) {
            return null;
        }
        SerdeUtils.throwOnColumnCountMismatch(this.numColumns, values.size(), false, topic);
        return this.factory.apply(values);
    }
}

