/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.CompatibleElement;
import java.util.Arrays;
import java.util.Set;

public enum SchemaTranslationPolicy implements CompatibleElement<SchemaTranslationPolicy>
{
    UPPERCASE_FIELD_NAME("ORIGINAL_FIELD_NAME"),
    ORIGINAL_FIELD_NAME("UPPERCASE_FIELD_NAME");

    private final ImmutableSet<String> unvalidated;
    private ImmutableSet<SchemaTranslationPolicy> incompatibleWith;

    private SchemaTranslationPolicy(String ... incompatibleWith) {
        this.unvalidated = ImmutableSet.copyOf((Object[])incompatibleWith);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="incompatibleWith is ImmutableSet")
    public Set<SchemaTranslationPolicy> getIncompatibleWith() {
        return this.incompatibleWith;
    }

    private void validate() {
        this.incompatibleWith = (ImmutableSet)this.unvalidated.stream().map(SchemaTranslationPolicy::valueOf).collect(ImmutableSet.toImmutableSet());
    }

    static {
        Arrays.stream(SchemaTranslationPolicy.values()).forEach(SchemaTranslationPolicy::validate);
    }
}

