/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import io.confluent.ksql.serde.avro.AvroSchemas;
import io.confluent.ksql.serde.avro.AvroUtil;
import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.DataTranslator;
import io.confluent.ksql.util.DecimalUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class AvroDataTranslator
implements DataTranslator {
    private final DataTranslator innerTranslator;
    private final Schema ksqlSchema;
    private final Schema avroCompatibleSchema;

    AvroDataTranslator(Schema schema, String schemaFullName) {
        this.ksqlSchema = AvroUtil.throwOnInvalidSchema(Objects.requireNonNull(schema, "schema"));
        this.avroCompatibleSchema = AvroSchemas.getAvroCompatibleConnectSchema(schema, schemaFullName);
        this.innerTranslator = new ConnectDataTranslator(this.avroCompatibleSchema);
    }

    Schema getAvroCompatibleSchema() {
        return this.avroCompatibleSchema;
    }

    @Override
    public Object toKsqlRow(Schema connectSchema, Object connectObject) {
        Object avroCompatibleRow = this.innerTranslator.toKsqlRow(connectSchema, connectObject);
        if (avroCompatibleRow == null) {
            return null;
        }
        return AvroDataTranslator.replaceSchema(this.ksqlSchema, avroCompatibleRow);
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        Object compatible = AvroDataTranslator.replaceSchema(this.avroCompatibleSchema, ksqlData);
        return this.innerTranslator.toConnectRow(compatible);
    }

    private static Struct convertStruct(Struct source, Schema targetSchema) {
        Struct struct = new Struct(targetSchema);
        Iterator sourceIt = source.schema().fields().iterator();
        for (Field targetField : targetSchema.fields()) {
            Field sourceField = (Field)sourceIt.next();
            Object value = source.get(sourceField);
            Object adjusted = AvroDataTranslator.replaceSchema(targetField.schema(), value);
            struct.put(targetField, adjusted);
        }
        return struct;
    }

    private static Object replaceSchema(Schema schema, Object object) {
        if (object == null) {
            return null;
        }
        switch (schema.type()) {
            case ARRAY: {
                ArrayList ksqlArray = new ArrayList(((List)object).size());
                ((List)object).forEach(e -> ksqlArray.add(AvroDataTranslator.replaceSchema(schema.valueSchema(), e)));
                return ksqlArray;
            }
            case MAP: {
                HashMap ksqlMap = new HashMap();
                ((Map)object).forEach((key, value) -> ksqlMap.put(AvroDataTranslator.replaceSchema(schema.keySchema(), key), AvroDataTranslator.replaceSchema(schema.valueSchema(), value)));
                return ksqlMap;
            }
            case STRUCT: {
                return AvroDataTranslator.convertStruct((Struct)object, schema);
            }
            case BYTES: {
                if (DecimalUtil.isDecimal((Schema)schema)) {
                    return DecimalUtil.ensureFit((BigDecimal)((BigDecimal)object), (Schema)schema);
                }
                return object;
            }
        }
        return object;
    }
}

