/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.avro;

import io.confluent.ksql.serde.connect.ConnectSRSchemaDataTranslator;
import io.confluent.ksql.util.KsqlException;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class AvroSRSchemaDataTranslator
extends ConnectSRSchemaDataTranslator {
    AvroSRSchemaDataTranslator(Schema schema) {
        super(schema);
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        if (!(ksqlData instanceof Struct)) {
            return ksqlData;
        }
        Schema schema = this.getSchema();
        Struct struct = new Struct(schema);
        Struct originalData = (Struct)ksqlData;
        Schema originalSchema = originalData.schema();
        this.validate(originalSchema, schema);
        for (Field field : schema.fields()) {
            Optional<Field> originalField = originalSchema.fields().stream().filter(f -> field.name().equals(f.name())).findFirst();
            if (originalField.isPresent()) {
                struct.put(field, originalData.get(originalField.get()));
                continue;
            }
            if (field.schema().defaultValue() != null || field.schema().isOptional()) {
                struct.put(field, field.schema().defaultValue());
                continue;
            }
            throw new KsqlException("Missing default value for required Avro field: [" + field.name() + "]. This field appears in Avro schema in Schema Registry");
        }
        return struct;
    }
}

