/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.connect;

import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import java.util.List;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class ConnectSchemas {
    private ConnectSchemas() {
    }

    public static ConnectSchema columnsToConnectSchema(List<? extends SimpleColumn> columns) {
        SchemaConverters.SqlToConnectTypeConverter converter = SchemaConverters.sqlToConnectConverter();
        SchemaBuilder builder = SchemaBuilder.struct();
        for (SimpleColumn simpleColumn : columns) {
            Schema colSchema = converter.toConnectSchema(simpleColumn.type());
            builder.field(simpleColumn.name().text(), colSchema);
        }
        return (ConnectSchema)builder.build();
    }
}

