/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.delimited;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.types.SqlPrimitiveType;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.serde.Delimiter;
import io.confluent.ksql.serde.Format;
import io.confluent.ksql.serde.FormatProperties;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeUtils;
import io.confluent.ksql.serde.delimited.KsqlDelimitedDeserializer;
import io.confluent.ksql.serde.delimited.KsqlDelimitedSerializer;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.csv.CSVFormat;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;

public final class DelimitedFormat
implements Format {
    private static final ImmutableSet<SerdeFeature> SUPPORTED_FEATURES = ImmutableSet.of((Object)SerdeFeature.UNWRAP_SINGLES);
    private static final String DEFAULT_DELIMITER = ",";
    public static final String DELIMITER = "delimiter";
    public static final String NAME = "DELIMITED";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="SUPPORTED_FEATURES is ImmutableSet")
    public Set<SerdeFeature> supportedFeatures() {
        return SUPPORTED_FEATURES;
    }

    @Override
    public Set<String> getSupportedProperties() {
        return ImmutableSet.of((Object)DELIMITER);
    }

    @Override
    public Serde<List<?>> getSerde(PersistenceSchema schema, Map<String, String> formatProperties, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> srClientFactory, boolean isKey) {
        FormatProperties.validateProperties(this.name(), formatProperties, this.getSupportedProperties());
        SerdeUtils.throwOnUnsupportedFeatures(schema.features(), this.supportedFeatures());
        Delimiter delimiter = DelimitedFormat.getDelimiter(formatProperties);
        CSVFormat csvFormat = CSVFormat.DEFAULT.withDelimiter(delimiter.getDelimiter());
        return Serdes.serdeFrom((Serializer)new KsqlDelimitedSerializer(schema, csvFormat), (Deserializer)new KsqlDelimitedDeserializer(schema, csvFormat));
    }

    private static Delimiter getDelimiter(Map<String, String> formatProperties) {
        return Delimiter.parse((String)formatProperties.getOrDefault(DELIMITER, DEFAULT_DELIMITER));
    }

    @Override
    public boolean supportsKeyType(SqlType type) {
        return type instanceof SqlPrimitiveType;
    }
}

