/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.delimited;

import io.confluent.ksql.schema.ksql.PersistenceSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.serde.SerdeUtils;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Serializer;

class KsqlDelimitedSerializer
implements Serializer<List<?>> {
    private static Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    private final PersistenceSchema schema;
    private final CSVFormat csvFormat;

    KsqlDelimitedSerializer(PersistenceSchema schema, CSVFormat csvFormat) {
        this.schema = Objects.requireNonNull(schema, "schema");
        this.csvFormat = Objects.requireNonNull(csvFormat, "csvFormat");
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public byte[] serialize(String topic, List<?> data) {
        if (data == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            CSVPrinter csvPrinter = new CSVPrinter((Appendable)stringWriter, this.csvFormat);
            csvPrinter.printRecord(() -> new FieldIterator(data, this.schema));
            String result = stringWriter.toString();
            return result.substring(0, result.length() - 2).getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new SerializationException("Error serializing CSV message", (Throwable)e);
        }
    }

    public void close() {
    }

    private static class FieldIterator
    implements Iterator<Object> {
        private final Iterator<?> dataIt;
        private final Iterator<SimpleColumn> columnIt;

        FieldIterator(List<?> data, PersistenceSchema schema) {
            this.dataIt = data.iterator();
            this.columnIt = schema.columns().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.columnIt.hasNext();
        }

        @Override
        public Object next() {
            Object value = this.dataIt.next();
            SimpleColumn column = this.columnIt.next();
            switch (column.type().baseType()) {
                case DECIMAL: {
                    return FieldIterator.handleDecimal((BigDecimal)value);
                }
                case BYTES: {
                    return FieldIterator.handleBytes((ByteBuffer)value);
                }
                case TIME: {
                    return FieldIterator.handleTime((Time)value);
                }
                case DATE: {
                    return FieldIterator.handleDate((Date)value);
                }
                case TIMESTAMP: {
                    return FieldIterator.handleTimestamp((Timestamp)value);
                }
            }
            return value;
        }

        private static String handleBytes(ByteBuffer value) {
            return value == null ? null : BASE64_ENCODER.encodeToString(value.array());
        }

        private static Integer handleTime(Time value) {
            return value == null ? null : Integer.valueOf((int)value.getTime());
        }

        private static Integer handleDate(Date value) {
            return value == null ? null : Integer.valueOf(SerdeUtils.toEpochDays(value));
        }

        private static Long handleTimestamp(Timestamp value) {
            return value == null ? null : Long.valueOf(value.getTime());
        }

        private static String handleDecimal(BigDecimal value) {
            return value.toPlainString();
        }
    }
}

