/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import io.confluent.ksql.serde.connect.ConnectDataTranslator;
import io.confluent.ksql.serde.connect.DataTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufSchemas;
import java.util.Iterator;
import java.util.Objects;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class ProtobufDataTranslator
implements DataTranslator {
    private final DataTranslator innerTranslator;
    private final Schema ksqlSchema;
    private final Schema protoCompatibleSchema;

    ProtobufDataTranslator(Schema schema, String schemaFullName) {
        this.ksqlSchema = Objects.requireNonNull(schema, "schema");
        this.protoCompatibleSchema = ProtobufSchemas.schemaWithName(schema, schemaFullName);
        this.innerTranslator = new ConnectDataTranslator(this.protoCompatibleSchema);
    }

    Schema getSchema() {
        return this.protoCompatibleSchema;
    }

    @Override
    public Object toKsqlRow(Schema connectSchema, Object connectObject) {
        Object protoCompatibleRow = this.innerTranslator.toKsqlRow(connectSchema, connectObject);
        if (protoCompatibleRow == null) {
            return null;
        }
        return ProtobufDataTranslator.objectWithSchema(this.ksqlSchema, protoCompatibleRow);
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        Object compatible = ProtobufDataTranslator.objectWithSchema(this.protoCompatibleSchema, ksqlData);
        return this.innerTranslator.toConnectRow(compatible);
    }

    private static Object objectWithSchema(Schema schema, Object object) {
        if (object == null || schema.type() != Schema.Type.STRUCT) {
            return object;
        }
        Struct source = (Struct)object;
        Struct struct = new Struct(schema);
        Iterator sourceIt = source.schema().fields().iterator();
        for (Field targetField : schema.fields()) {
            Field sourceField = (Field)sourceIt.next();
            Object value = source.get(sourceField);
            struct.put(targetField, value);
        }
        return struct;
    }
}

