/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.serde.connect.ConnectProperties;
import java.util.Map;

public class ProtobufProperties
extends ConnectProperties {
    public static final String UNWRAP_PRIMITIVES = "unwrapPrimitives";
    public static final String UNWRAP = "true";
    private static final String WRAP = "false";
    static final ImmutableSet<String> SUPPORTED_PROPERTIES = ImmutableSet.of((Object)"fullSchemaName", (Object)"schemaId", (Object)"unwrapPrimitives", (Object)"subjectName");
    static final ImmutableSet<String> INHERITABLE_PROPERTIES = ImmutableSet.of((Object)"fullSchemaName");

    public ProtobufProperties(Map<String, String> formatProps) {
        super("PROTOBUF", formatProps);
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public ImmutableSet<String> getSupportedProperties() {
        return SUPPORTED_PROPERTIES;
    }

    @Override
    public String getDefaultFullSchemaName() {
        return null;
    }

    public boolean getUnwrapPrimitives() {
        return UNWRAP.equalsIgnoreCase((String)this.properties.getOrDefault((Object)UNWRAP_PRIMITIVES, (Object)WRAP));
    }

    public ProtobufProperties withFullSchemaName(String name) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll((Map)this.properties);
        builder.put((Object)"fullSchemaName", (Object)name);
        return new ProtobufProperties((Map<String, String>)builder.build());
    }
}

