/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import io.confluent.ksql.serde.connect.ConnectSRSchemaDataTranslator;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class ProtobufSRSchemaDataTranslator
extends ConnectSRSchemaDataTranslator {
    public ProtobufSRSchemaDataTranslator(Schema schema) {
        super(schema);
    }

    @Override
    public Object toConnectRow(Object ksqlData) {
        if (!(ksqlData instanceof Struct)) {
            return ksqlData;
        }
        return this.compatibleWithSchema(ksqlData, this.getSchema());
    }

    private Object compatibleWithSchema(Object object, Schema schema) {
        if (object == null) {
            return object;
        }
        switch (schema.type()) {
            case ARRAY: {
                ArrayList ksqlArray = new ArrayList(((List)object).size());
                ((List)object).forEach(e -> ksqlArray.add(this.compatibleWithSchema(e, schema.valueSchema())));
                return ksqlArray;
            }
            case MAP: {
                HashMap ksqlMap = new HashMap();
                ((Map)object).forEach((key, value) -> ksqlMap.put(this.compatibleWithSchema(key, schema.keySchema()), this.compatibleWithSchema(value, schema.valueSchema())));
                return ksqlMap;
            }
            case STRUCT: {
                return this.convertStruct((Struct)object, schema);
            }
        }
        return object;
    }

    private Struct convertStruct(Struct source, Schema targetSchema) {
        Struct struct = new Struct(targetSchema);
        Schema originalSchema = source.schema();
        this.validate(originalSchema, targetSchema);
        for (Field field : targetSchema.fields()) {
            Optional<Field> originalField = originalSchema.fields().stream().filter(f -> field.name().equals(f.name())).findFirst();
            if (originalField.isPresent()) {
                Object originalValue = source.get(originalField.get());
                struct.put(field, this.compatibleWithSchema(originalValue, field.schema()));
                continue;
            }
            if (field.schema().defaultValue() != null || field.schema().isOptional()) {
                struct.put(field, field.schema().defaultValue());
                continue;
            }
            throw new KsqlException("Missing default value for required Protobuf field: [" + field.name() + "]. This field appears in Protobuf schema in Schema Registry");
        }
        return struct;
    }
}

