/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.confluent.connect.protobuf.ProtobufData;
import io.confluent.connect.protobuf.ProtobufDataConfig;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.ksql.serde.connect.ConnectSchemaTranslator;
import io.confluent.ksql.serde.protobuf.ProtobufProperties;
import io.confluent.ksql.serde.protobuf.ProtobufSchemas;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;

public class ProtobufSchemaTranslator
implements ConnectSchemaTranslator {
    private static final String DEFAULT_PREFIX_SCHEMA_NAME = "ConnectDefault";
    private final Map<String, Object> baseConfigs;
    private final Optional<String> fullNameSchema;
    private Map<String, Object> updatedConfigs;
    private ProtobufData protobufData;

    public ProtobufSchemaTranslator(ProtobufProperties properties) {
        Objects.requireNonNull(properties, "properties");
        this.baseConfigs = ImmutableMap.of((Object)"wrapper.for.raw.primitives", (Object)properties.getUnwrapPrimitives(), (Object)"enhanced.protobuf.schema.support", (Object)"true");
        this.fullNameSchema = this.ignoreDefaultName(properties.getFullSchemaName());
        this.updatedConfigs = this.baseConfigs;
        this.protobufData = new ProtobufData(new ProtobufDataConfig(this.baseConfigs));
    }

    private Optional<String> ignoreDefaultName(String fullNameSchema) {
        if (fullNameSchema == null) {
            return Optional.empty();
        }
        String trimmedName = fullNameSchema.trim();
        if (trimmedName.startsWith(DEFAULT_PREFIX_SCHEMA_NAME)) {
            return Optional.empty();
        }
        return Optional.ofNullable(Strings.emptyToNull((String)trimmedName));
    }

    @Override
    public void configure(Map<String, ?> configs) {
        HashMap mergedConfigs = new HashMap(configs);
        mergedConfigs.putAll(this.baseConfigs);
        this.updatedConfigs = mergedConfigs;
        this.protobufData = new ProtobufData(new ProtobufDataConfig(mergedConfigs));
    }

    @Override
    public String name() {
        return "PROTOBUF";
    }

    @Override
    public Schema toConnectSchema(ParsedSchema schema) {
        return this.protobufData.toConnectSchema(this.withSchemaFullName((ProtobufSchema)schema));
    }

    @Override
    public ParsedSchema fromConnectSchema(Schema schema) {
        return new ProtobufData(new ProtobufDataConfig(this.updatedConfigs)).fromConnectSchema(this.injectSchemaFullName(schema));
    }

    private ProtobufSchema withSchemaFullName(ProtobufSchema origSchema) {
        return this.fullNameSchema.map(arg_0 -> ((ProtobufSchema)origSchema).copy(arg_0)).orElse(origSchema);
    }

    private Schema injectSchemaFullName(Schema origSchema) {
        return this.fullNameSchema.map(fullName -> ProtobufSchemas.schemaWithName(origSchema, fullName)).orElse(origSchema);
    }
}

