/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.serde.protobuf;

import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public final class ProtobufSchemas {
    private ProtobufSchemas() {
    }

    static Schema schemaWithName(Schema schema, String schemaName) {
        if (schemaName == null || schema.type() != Schema.Type.STRUCT) {
            return schema;
        }
        SchemaBuilder builder = SchemaBuilder.struct();
        for (Field f : schema.fields()) {
            builder.field(f.name(), f.schema());
        }
        if (schema.parameters() != null) {
            builder.parameters(schema.parameters());
        }
        if (schema.isOptional()) {
            builder.optional();
        }
        if (schema.defaultValue() != null) {
            builder.defaultValue(schema.defaultValue());
        }
        builder.doc(schema.doc());
        builder.version(schema.version());
        return builder.name(schemaName).build();
    }
}

