/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.serializers;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.errors.SerializationException;

public class OrderedBytes {
    public static final int NULL_SIZE = 1;
    public static final int FIXED_INT_16_SIZE = 3;
    public static final int FIXED_INT_32_SIZE = 5;
    public static final int FIXED_INT_64_SIZE = 9;
    private static final int MAX_UTF8_BYTES = 4;
    public static final byte MARKER_NULL = 5;
    public static final byte MARKER_START_STRING = 52;
    public static final byte MARKER_END_STRING = 0;
    public static final byte MARKER_START_FIXED_INT_16 = 42;
    public static final byte MARKER_START_FIXED_INT_32 = 43;
    public static final byte MARKER_START_FIXED_INT_64 = 44;

    public static int writeNull(ByteBuffer buffer) {
        buffer.put((byte)5);
        return 1;
    }

    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (array.length < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static int getMaxNumBytes(String string) {
        return string.length() * 4 + 2;
    }

    public static String readString(ByteBuffer buffer) {
        byte marker = buffer.get();
        if (marker == 5) {
            return null;
        }
        if (marker != 52) {
            throw new SerializationException("Unexpected type marker for string: " + marker);
        }
        int len = OrderedBytes.getStringLength(buffer);
        byte[] strBytes = new byte[len];
        buffer.get(strBytes, buffer.arrayOffset(), len);
        byte endMarker = buffer.get();
        assert (endMarker == 0);
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    private static int getStringLength(ByteBuffer buffer) {
        byte[] bytes = buffer.array();
        for (int len = 0; len <= buffer.remaining(); ++len) {
            if (bytes[buffer.arrayOffset() + buffer.position() + len] != 0) continue;
            return len;
        }
        throw new SerializationException("No end of string found");
    }

    public static int writeString(ByteBuffer buffer, String value) {
        if (value == null) {
            return OrderedBytes.writeNull(buffer);
        }
        int start = buffer.position();
        buffer.put((byte)52);
        buffer.put(value.getBytes(StandardCharsets.UTF_8));
        buffer.put((byte)0);
        int numBytes = buffer.position() - start;
        assert (numBytes <= OrderedBytes.getMaxNumBytes(value));
        return numBytes;
    }

    public static Integer readInt(ByteBuffer buffer) {
        byte marker = buffer.get();
        if (marker == 5) {
            return null;
        }
        if (marker != 43) {
            throw new SerializationException("Unexpected type marker for int: " + marker);
        }
        buffer.order(ByteOrder.BIG_ENDIAN);
        return OrderedBytes.flipSignBit(buffer.getInt());
    }

    public static int writeInt(ByteBuffer buffer, Integer value) {
        if (value == null) {
            return OrderedBytes.writeNull(buffer);
        }
        int start = buffer.position();
        buffer.put((byte)43);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(OrderedBytes.flipSignBit(value));
        assert (buffer.position() - start == 5);
        return 5;
    }

    public static Long readLong(ByteBuffer buffer) {
        byte marker = buffer.get();
        if (marker == 5) {
            return null;
        }
        if (marker != 44) {
            throw new SerializationException("Unexpected type marker for long: " + marker);
        }
        buffer.order(ByteOrder.BIG_ENDIAN);
        return OrderedBytes.flipSignBit(buffer.getLong());
    }

    public static int writeLong(ByteBuffer buffer, Long value) {
        if (value == null) {
            return OrderedBytes.writeNull(buffer);
        }
        int start = buffer.position();
        buffer.put((byte)44);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(OrderedBytes.flipSignBit(value));
        assert (buffer.position() - start == 9);
        return 9;
    }

    public static Short readShort(ByteBuffer buffer) {
        byte marker = buffer.get();
        if (marker == 5) {
            return null;
        }
        if (marker != 42) {
            throw new SerializationException("Unexpected type marker for short: " + marker);
        }
        buffer.order(ByteOrder.BIG_ENDIAN);
        return OrderedBytes.flipSignBit(buffer.getShort());
    }

    public static int writeShort(ByteBuffer buffer, Short value) {
        if (value == null) {
            return OrderedBytes.writeNull(buffer);
        }
        int start = buffer.position();
        buffer.put((byte)42);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putShort(OrderedBytes.flipSignBit(value));
        assert (buffer.position() - start == 3);
        return 3;
    }

    public static long flipSignBit(long in) {
        return in ^ Long.MIN_VALUE;
    }

    public static int flipSignBit(int in) {
        return in ^ Integer.MIN_VALUE;
    }

    public static short flipSignBit(short in) {
        return (short)(in ^ Short.MIN_VALUE);
    }
}

