/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.config;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public final class DbAuthStoreConfig
extends AbstractConfig {
    public static final String CONFIG_PREFIX = "confluent.metadata.server.db.";
    public static final String NUM_WRITER_POOL_THREADS_CONFIG = "confluent.metadata.server.db.writer.num.thread.pool.threads";
    public static final String NUM_WRITER_POOL_THREADS_DOC = "The number of DB writer thread pool threads.";
    public static final int NUM_WRITER_POOL_THREADS_DEFAULT = 10;
    public static final String NUM_READER_POOL_THREADS_CONFIG = "confluent.metadata.server.db.reader.num.thread.pool.threads";
    public static final String NUM_READER_POOL_THREADS_DOC = "The number of DB reader thread pool threads.";
    public static final int NUM_READER_POOL_THREADS_DEFAULT = 20;
    public static final String DB_READ_TIMEOUT_SEC_CONFIG = "confluent.metadata.server.db.read.timeout.sec";
    public static final String DB_READ_TIMEOUT_SEC_DOC = "How long to wait for the DB reads to complete, in seconds";
    public static final int DB_READ_TIMEOUT_SEC_DEFAULT = 10;
    public static final String DB_AUTH_CACHE_MAX_SIZE_CONFIG = "confluent.metadata.server.db.auth.cache.max.size";
    public static final String DB_AUTH_CACHE_MAX_SIZE_DOC = "the maximum size of the per user DB auth cache. Set 0 to disable caching.";
    public static final int DB_AUTH_CACHE_MAX_SIZE_DEFAULT = 0;
    public static final String DB_AUTH_CACHE_TTL_MS_CONFIG = "confluent.metadata.server.db.auth.cache.ttl.ms";
    public static final String DB_AUTH_CACHE_TTL_MS_DOC = "The length of time in milli seconds after an entry is created that it should be automatically removed";
    public static final int DB_AUTH_CACHE_TTL_MS_DEFAULT = 10000;
    public static final String DB_URL_CONFIG = "confluent.metadata.server.db.url";
    public static final String DB_URL_DOC = "JDBC URL to connect to the DB";
    public static final String DB_USERNAME_CONFIG = "confluent.metadata.server.db.username";
    public static final String DB_USERNAME_DOC = "DB username";
    public static final String DB_PASSWORD_CONFIG = "confluent.metadata.server.db.password";
    public static final String DB_PASSWORD_DOC = "DB password";
    public static final String DB_SKIP_HEALTHCHECK_CONFIG = "confluent.metadata.server.db.skip.healthcheck";
    public static final String DB_SKIP_HEALTHCHECK_DOC = "Whether to skip db healthcheck on initial startup. This should only be necessary in cases where the db is not available until after kafka startup, for example in cpd. Ideally, this should be replaced with CIAM-304";
    public static final boolean DB_SKIP_HEALTHCHECK_DEFAULT = false;
    public static final String DB_CONNECTION_POOL_SIZE_CONFIG = "confluent.metadata.server.db.connection.pool.size";
    public static final String DB_CONNECTION_POOL_SIZE_DOC = "The size of the DB connection pool.";
    public static final int DB_CONNECTION_POOL_SIZE_DEFAULT = 10;
    private static final ConfigDef CONFIG = new ConfigDef().define("confluent.metadata.server.db.writer.num.thread.pool.threads", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.HIGH, "The number of DB writer thread pool threads.").define("confluent.metadata.server.db.reader.num.thread.pool.threads", ConfigDef.Type.INT, (Object)20, ConfigDef.Importance.HIGH, "The number of DB reader thread pool threads.").define("confluent.metadata.server.db.read.timeout.sec", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.HIGH, "How long to wait for the DB reads to complete, in seconds").define("confluent.metadata.server.db.auth.cache.max.size", ConfigDef.Type.INT, (Object)0, ConfigDef.Importance.HIGH, "the maximum size of the per user DB auth cache. Set 0 to disable caching.").define("confluent.metadata.server.db.auth.cache.ttl.ms", ConfigDef.Type.INT, (Object)10000, ConfigDef.Importance.HIGH, "The length of time in milli seconds after an entry is created that it should be automatically removed").define("confluent.metadata.server.db.url", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "JDBC URL to connect to the DB").define("confluent.metadata.server.db.username", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "DB username").define("confluent.metadata.server.db.password", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "DB password").define("confluent.metadata.server.db.skip.healthcheck", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Whether to skip db healthcheck on initial startup. This should only be necessary in cases where the db is not available until after kafka startup, for example in cpd. Ideally, this should be replaced with CIAM-304").define("confluent.metadata.server.db.connection.pool.size", ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.HIGH, "The size of the DB connection pool.");

    public DbAuthStoreConfig(Map<?, ?> props) {
        super(CONFIG, props);
    }
}

