/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.kafka;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.rbacdb.config.DbAuthStoreConfig;
import io.confluent.rbacdb.exception.DbAuthStoreException;
import io.confluent.rbacdb.kafka.DbAuthCacheMetrics;
import io.confluent.rbacdb.orm.RbacOrmService;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.store.cache.DefaultAuthCache;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.RoleBindingKey;
import io.confluent.security.auth.store.data.RoleBindingValue;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.authorizer.utils.ThreadUtils;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import io.confluent.security.rbac.UserMetadata;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAuthCache
implements AuthCache,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(DbAuthCache.class);
    private final RbacOrmService rbacDBService;
    private final Scope rootScope;
    private final DbAuthCacheMetrics metrics;
    private final int readTimeoutSecs;
    private final RbacRoles rbacRoles;
    private final LoadingCache<KafkaPrincipal, DefaultAuthCache> perUserAuthCache;
    private final ThreadPoolExecutor executor;

    public DbAuthCache(Scope rootScope, DbAuthStoreConfig dbAuthStoreConfig, RbacOrmService rbacDBService, Metrics metrics) {
        this(RbacRoles.loadDefaultPolicy((boolean)true), rootScope, dbAuthStoreConfig, rbacDBService, metrics);
    }

    public DbAuthCache(RbacRoles rbacRoles, Scope rootScope, DbAuthStoreConfig dbAuthStoreConfig, RbacOrmService rbacDBService, Metrics metrics) {
        this.rbacRoles = rbacRoles;
        this.rootScope = rootScope;
        this.rbacDBService = rbacDBService;
        this.executor = new ThreadPoolExecutor((int)dbAuthStoreConfig.getInt("confluent.metadata.server.db.reader.num.thread.pool.threads"), (int)dbAuthStoreConfig.getInt("confluent.metadata.server.db.reader.num.thread.pool.threads"), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.createThreadFactory((String)"mds-db-authcache-%d", (boolean)true));
        this.readTimeoutSecs = dbAuthStoreConfig.getInt("confluent.metadata.server.db.read.timeout.sec");
        int cacheMaxEntries = dbAuthStoreConfig.getInt("confluent.metadata.server.db.auth.cache.max.size");
        int cacheTTLMs = dbAuthStoreConfig.getInt("confluent.metadata.server.db.auth.cache.ttl.ms");
        this.perUserAuthCache = CacheBuilder.newBuilder().maximumSize((long)cacheMaxEntries).expireAfterWrite((long)cacheTTLMs, TimeUnit.MILLISECONDS).recordStats().build((CacheLoader)new CacheLoader<KafkaPrincipal, DefaultAuthCache>(){

            public DefaultAuthCache load(KafkaPrincipal userPrincipal) {
                return DbAuthCache.this.loadPerUserAuthCache(userPrincipal);
            }
        });
        this.metrics = new DbAuthCacheMetrics(metrics, "mds-db-authcache", this.executor, this.perUserAuthCache, rbacDBService);
    }

    private DefaultAuthCache loadPerUserAuthCache(KafkaPrincipal userPrincipal) {
        Set<RoleBinding> roleBindings = this.rbacRoleBindings(userPrincipal);
        DefaultAuthCache perUserDefaultAuthCache = new DefaultAuthCache(this.rbacRoles, this.rootScope);
        for (RoleBinding roleBinding : roleBindings) {
            perUserDefaultAuthCache.put((AuthKey)new RoleBindingKey(roleBinding.principal(), roleBinding.role(), roleBinding.scope()), (AuthValue)new RoleBindingValue(roleBinding.resources()));
        }
        return perUserDefaultAuthCache;
    }

    public RbacRoles rbacRoles() {
        return this.rbacRoles;
    }

    public Set<RoleBinding> rbacRoleBindings(Scope scope) {
        return this.rbacRoleBindings(Collections.singleton(scope));
    }

    public Set<RoleBinding> rbacRoleBindings(Set<Scope> scopes) {
        this.metrics.request().record();
        CompletableFuture<Set<RoleBinding>> future = CompletableFuture.supplyAsync(() -> this.rbacDBService.rbacRoleBindings(scopes), this.executor);
        return this.handleFuture(future);
    }

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal) {
        this.metrics.request().record();
        CompletableFuture<Set<RoleBinding>> future = CompletableFuture.supplyAsync(() -> this.rbacDBService.rbacRoleBindings(principal), this.executor);
        return this.handleFuture(future);
    }

    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal, Set<Scope> scopes) {
        this.metrics.request().record();
        CompletableFuture<Set<RoleBinding>> future = CompletableFuture.supplyAsync(() -> this.rbacDBService.rbacRoleBindings(principal, scopes), this.executor);
        return this.handleFuture(future);
    }

    public Set<RoleBinding> rbacRoleBindings(RoleBindingFilter filter) {
        this.metrics.request().record();
        CompletableFuture<Set<RoleBinding>> future = CompletableFuture.supplyAsync(() -> this.rbacDBService.rbacRoleBindings(filter), this.executor);
        return this.handleFuture(future);
    }

    private Set<RoleBinding> handleFuture(CompletableFuture<Set<RoleBinding>> future) {
        try {
            return future.get(this.readTimeoutSecs, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.metrics.requestError().record();
            log.error("Timeout while RbacOrmService.rbacRoleBindings() call.", (Throwable)e);
            throw new DbAuthStoreException("RbacOrmService.rbacRoleBindings() call failed becauseof a timeout in future.get().", e);
        }
        catch (InterruptedException | ExecutionException e) {
            this.metrics.requestError().record();
            log.error("Exception while RbacOrmService.rbacRoleBindings() call.", (Throwable)e);
            throw new DbAuthStoreException("RbacOrmService.rbacRoleBindings() call failed.", e);
        }
    }

    public Set<Scope> knownScopes() {
        this.metrics.request().record();
        CompletableFuture<Set> future = CompletableFuture.supplyAsync(this.rbacDBService::knownScopes, this.executor);
        try {
            return future.get(this.readTimeoutSecs, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.metrics.requestError().record();
            log.error("Timeout while RbacOrmService.knownScopes() call.", (Throwable)e);
            throw new DbAuthStoreException("RbacOrmService.knownScopes() call failed becauseof a timeout in future.get().", e);
        }
        catch (InterruptedException | ExecutionException e) {
            this.metrics.requestError().record();
            log.error("Exception while RbacOrmService.knownScopes() call.", (Throwable)e);
            throw new DbAuthStoreException("RbacOrmService.knownScopes() call failed.", e);
        }
    }

    public Scope rootScope() {
        return this.rootScope;
    }

    public Set<KafkaPrincipal> groups(KafkaPrincipal userPrincipal) {
        return Collections.emptySet();
    }

    public UserMetadata userMetadata(KafkaPrincipal userPrincipal) {
        throw new UnsupportedOperationException();
    }

    public Map<KafkaPrincipal, UserMetadata> users() {
        throw new UnsupportedOperationException();
    }

    public AuthorizeRule findRule(KafkaPrincipal userPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Action action) {
        try {
            this.metrics.findRuleInvocation().record();
            DefaultAuthCache authCache = (DefaultAuthCache)this.perUserAuthCache.get((Object)userPrincipal);
            return authCache.findRule(userPrincipal, groupPrincipals, host, action);
        }
        catch (ExecutionException e) {
            log.warn("Failure while getting perUserAuthCache.", (Throwable)e);
            return new AuthorizeRule();
        }
    }

    public void addMatchingRules(ResourceAuthorizeRules resourceAuthorizeRules, KafkaPrincipal kafkaPrincipal, Set<KafkaPrincipal> set, String s, Operation operation, Scope scope, ResourceType resourceType) {
        throw new UnsupportedOperationException();
    }

    public AuthCache.Result healthcheck() {
        try {
            this.rbacDBService.healthcheck();
            return AuthCache.Result.healthy();
        }
        catch (Exception e) {
            return AuthCache.Result.unhealthy((String)e.getMessage());
        }
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.metrics.close();
    }

    public Collection<AclBinding> aclBindings(Scope scope, AclBindingFilter aclBindingFilter, Predicate<ResourcePattern> resourceAccess) {
        throw new UnsupportedOperationException();
    }

    public Map<ResourcePattern, Set<AccessRule>> aclRules(Scope scope) {
        throw new UnsupportedOperationException();
    }
}

