/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.kafka;

import com.google.common.cache.LoadingCache;
import io.confluent.rbacdb.kafka.DbRequestMetrics;
import io.confluent.rbacdb.orm.RbacOrmService;
import java.util.Collections;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;

class DbAuthCacheMetrics
extends DbRequestMetrics {
    private final Sensor findRuleInvocation;

    DbAuthCacheMetrics(Metrics metrics, String metricGrpPrefix, ThreadPoolExecutor executor, LoadingCache<?, ?> cache, RbacOrmService rbacOrmService) {
        super(metrics, metricGrpPrefix, executor, rbacOrmService);
        String cacheSizeName = "cache-size";
        MetricName cacheSizeMetricName = metrics.metricName(cacheSizeName, this.metricGroupName, "The number of entries in the cache.", Collections.emptyMap());
        metrics.addMetric(cacheSizeMetricName, (config, now) -> cache.size());
        this.metricNames.add(cacheSizeMetricName);
        String hitCountName = "hit-count";
        MetricName hitCountMetricName = metrics.metricName(hitCountName, this.metricGroupName, "the number of times Cache lookup methods have returned a cached value.", Collections.emptyMap());
        metrics.addMetric(hitCountMetricName, (config, now) -> cache.stats().hitCount());
        this.metricNames.add(hitCountMetricName);
        String hitRateName = "hit-rate";
        MetricName hitRateMetricName = metrics.metricName(hitRateName, this.metricGroupName, "the ratio of cache requests which were hits.", Collections.emptyMap());
        metrics.addMetric(hitRateMetricName, (config, now) -> cache.stats().hitRate());
        this.metricNames.add(hitRateMetricName);
        String missCountName = "miss-count";
        MetricName missCountMetricName = metrics.metricName(missCountName, this.metricGroupName, " number of times Cache lookup methods have returned an uncached (newly loaded) value, or null", Collections.emptyMap());
        metrics.addMetric(missCountMetricName, (config, now) -> cache.stats().missCount());
        this.metricNames.add(missCountMetricName);
        String loadCountName = "load-count";
        MetricName loadCountMetricName = metrics.metricName(loadCountName, this.metricGroupName, "total number of times that Cache lookup methods attempted to load new values.", Collections.emptyMap());
        metrics.addMetric(loadCountMetricName, (config, now) -> cache.stats().loadCount());
        this.metricNames.add(loadCountMetricName);
        String loadExceptionName = "load-exception-count";
        MetricName loadExceptionMetricName = metrics.metricName(loadExceptionName, this.metricGroupName, "the number of times Cache lookup methods threw an exception while loading a new value.", Collections.emptyMap());
        metrics.addMetric(loadExceptionMetricName, (config, now) -> cache.stats().loadExceptionCount());
        this.metricNames.add(loadExceptionMetricName);
        String findRuleSensor = "findrule-sensor";
        String findRuleRate = "findrule-rate";
        this.findRuleInvocation = this.sensor(findRuleSensor);
        MetricName findRuleRateMetricName = metrics.metricName(findRuleRate, this.metricGroupName, "The number of DBAuthCache.findrule() calls per second.");
        this.findRuleInvocation.add(findRuleRateMetricName, (MeasurableStat)new Rate());
    }

    public Sensor findRuleInvocation() {
        return this.findRuleInvocation;
    }
}

