/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.kafka;

import io.confluent.cloud.lifecycle.CloudLifecycleService;
import io.confluent.cloud.lifecycle.CloudLifecycleServiceProvider;
import io.confluent.rbacdb.config.DbAuthStoreConfig;
import io.confluent.rbacdb.kafka.DbAuthCache;
import io.confluent.rbacdb.kafka.DbAuthWriter;
import io.confluent.rbacdb.orm.RbacOrmService;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.Metrics;

public class DbAuthStore
implements AuthStore,
CloudLifecycleServiceProvider {
    private final DbAuthCache authCache;
    private final DbAuthWriter writer;
    private Map<String, URL> urlMap;
    private RbacOrmService rbacOrmService;

    public DbAuthStore(Scope rootScope, DbAuthStoreConfig dbAuthStoreConfig, RbacOrmService rbacOrmService, Metrics metrics) {
        this(RbacRoles.loadDefaultPolicy((boolean)true), rootScope, dbAuthStoreConfig, rbacOrmService, metrics);
    }

    public DbAuthStore(RbacRoles rbacRoles, Scope rootScope, DbAuthStoreConfig dbAuthStoreConfig, RbacOrmService rbacOrmService, Metrics metrics) {
        this.authCache = new DbAuthCache(rbacRoles, rootScope, dbAuthStoreConfig, rbacOrmService, metrics);
        this.writer = new DbAuthWriter(rbacRoles, rootScope, dbAuthStoreConfig, rbacOrmService, metrics);
        this.rbacOrmService = rbacOrmService;
    }

    public DbAuthCache authCache() {
        return this.authCache;
    }

    public DbAuthWriter writer() {
        return this.writer;
    }

    public CloudLifecycleService cloudLifecycleService() {
        return this.rbacOrmService;
    }

    public boolean isMasterWriter() {
        return true;
    }

    public void configure(Map<String, ?> configs) {
    }

    public CompletionStage<Void> startReader() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletionStage<Void> startService(Collection<URL> serverUrls) {
        this.urlMap = serverUrls.stream().collect(Collectors.toMap(URL::getProtocol, url -> url));
        return CompletableFuture.completedFuture(null);
    }

    public URL masterWriterUrl(String protocol) {
        return this.urlMap.get(protocol);
    }

    public Integer masterWriterId() {
        throw new UnsupportedOperationException("This operation supported");
    }

    public Collection<URL> activeNodeUrls(String protocol) {
        return Collections.singletonList(this.masterWriterUrl(protocol));
    }

    public void close() {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.authCache != null) {
            this.authCache.close();
        }
    }
}

