/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.kafka;

import io.confluent.rbacdb.config.DbAuthStoreConfig;
import io.confluent.rbacdb.kafka.DbRequestMetrics;
import io.confluent.rbacdb.orm.RbacOrmService;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.auth.utils.AuthWriterUtils;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.utils.ThreadUtils;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.store.kafka.clients.Writer;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbAuthWriter
implements AuthWriter,
Writer,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(DbAuthWriter.class);
    private final RbacOrmService rbacDBService;
    private final DbRequestMetrics metrics;
    private final RbacRoles rbacRoles;
    private final Scope rootScope;
    private final ThreadPoolExecutor executor;

    public DbAuthWriter(Scope rootScope, DbAuthStoreConfig dbAuthStoreConfig, RbacOrmService rbacOrmService, Metrics metrics) {
        this(RbacRoles.loadDefaultPolicy((boolean)true), rootScope, dbAuthStoreConfig, rbacOrmService, metrics);
    }

    public DbAuthWriter(RbacRoles rbacRoles, Scope rootScope, DbAuthStoreConfig dbAuthStoreConfig, RbacOrmService rbacOrmService, Metrics metrics) {
        this.rbacRoles = rbacRoles;
        this.rootScope = rootScope;
        this.rbacDBService = rbacOrmService;
        this.executor = new ThreadPoolExecutor((int)dbAuthStoreConfig.getInt("confluent.metadata.server.db.writer.num.thread.pool.threads"), (int)dbAuthStoreConfig.getInt("confluent.metadata.server.db.writer.num.thread.pool.threads"), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), ThreadUtils.createThreadFactory((String)"mds-db-writer-%d", (boolean)true));
        this.metrics = new DbRequestMetrics(metrics, "mds-db-writer", this.executor, this.rbacDBService);
    }

    public CompletionStage<Void> addClusterRoleBinding(Optional<KafkaPrincipal> callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, String reason) {
        log.debug("addClusterRoleBinding targetPrincipal={} principal={} role={} scope={} reason={}", new Object[]{callingPrincipal, targetPrincipal, role, scope, reason});
        this.metrics.request().record();
        AuthWriterUtils.validateRoleBindingUpdate((String)role, (Scope)scope, Collections.emptyList(), (boolean)true, (Scope)this.rootScope, (RbacRoles)this.rbacRoles);
        return CompletableFuture.runAsync(this.metrics.callRecordingError(() -> this.rbacDBService.addRoleBinding(callingPrincipal.orElse(KafkaPrincipal.ANONYMOUS), targetPrincipal, role, scope, reason)), this.executor);
    }

    public CompletionStage<Void> removeRoleBinding(Optional<KafkaPrincipal> callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, String reason) {
        log.debug("removeRoleBinding targetPrincipal={} principal={} role={} scope={} reason={}", new Object[]{callingPrincipal, targetPrincipal, role, scope, reason});
        this.metrics.request().record();
        AuthWriterUtils.validateRoleBindingUpdate((String)role, (Scope)scope, Collections.emptySet(), (boolean)false, (Scope)this.rootScope, (RbacRoles)this.rbacRoles);
        return CompletableFuture.runAsync(this.metrics.callRecordingError(() -> this.rbacDBService.removeRoleBinding(callingPrincipal.orElse(KafkaPrincipal.ANONYMOUS), targetPrincipal, role, scope, reason)), this.executor);
    }

    public CompletionStage<Void> addResourceRoleBinding(Optional<KafkaPrincipal> callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, Collection<ResourcePattern> resources, String reason) {
        log.debug("addResourceRoleBinding callingPrincipal={} principal={} role={} reason={} scope={} resources={}", new Object[]{callingPrincipal, targetPrincipal, role, scope, resources, reason});
        this.metrics.request().record();
        AuthWriterUtils.validateRoleBindingUpdate((String)role, (Scope)scope, resources, (boolean)true, (Scope)this.rootScope, (RbacRoles)this.rbacRoles);
        AuthWriterUtils.validateRoleResources(resources);
        return CompletableFuture.runAsync(this.metrics.callRecordingError(() -> this.rbacDBService.addResourceRoleBindings(callingPrincipal.orElse(KafkaPrincipal.ANONYMOUS), targetPrincipal, role, scope, resources, reason)), this.executor);
    }

    public CompletionStage<Void> removeResourceRoleBinding(Optional<KafkaPrincipal> callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, Collection<ResourcePatternFilter> patternFilters, String reason) {
        log.debug("removeResourceRoleBinding callingPrincipal={} principal={} role={}  scope={} resources={} reason={}", new Object[]{callingPrincipal, targetPrincipal, role, scope, patternFilters, reason});
        this.metrics.request().record();
        AuthWriterUtils.validateRoleBindingUpdate((String)role, (Scope)scope, patternFilters, (boolean)true, (Scope)this.rootScope, (RbacRoles)this.rbacRoles);
        return CompletableFuture.runAsync(this.metrics.callRecordingError(() -> this.rbacDBService.removeResourceRoleBindings(callingPrincipal.orElse(KafkaPrincipal.ANONYMOUS), targetPrincipal, role, scope, patternFilters, reason)), this.executor);
    }

    public CompletionStage<Void> replaceResourceRoleBinding(Optional<KafkaPrincipal> callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, Collection<ResourcePattern> resources, String reason) {
        log.debug("replaceResourceRoleBinding callingPrincipal={} principal={} role={} scope={} resources={} reason={}", new Object[]{callingPrincipal, targetPrincipal, role, scope, resources, reason});
        this.metrics.request().record();
        AuthWriterUtils.validateRoleBindingUpdate((String)role, (Scope)scope, resources, (boolean)true, (Scope)this.rootScope, (RbacRoles)this.rbacRoles);
        AuthWriterUtils.validateRoleResources(resources);
        return CompletableFuture.runAsync(this.metrics.callRecordingError(() -> this.rbacDBService.replaceResourceRoleBindings(callingPrincipal.orElse(KafkaPrincipal.ANONYMOUS), targetPrincipal, role, scope, resources, reason)), this.executor);
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.metrics.close();
    }

    public CompletionStage<Void> createAcls(Optional<KafkaPrincipal> callingPrincipal, Scope scope, AclBinding aclBinding) {
        throw new UnsupportedOperationException();
    }

    public Map<AclBinding, CompletionStage<AclCreateResult>> createAcls(Optional<KafkaPrincipal> callingPrincipal, Scope scope, List<AclBinding> aclBindings) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<Collection<AclBinding>> deleteAcls(Optional<KafkaPrincipal> callingPrincipal, Scope scope, AclBindingFilter aclBindingFilter, Predicate<ResourcePattern> resourceAccess) {
        throw new UnsupportedOperationException();
    }

    public Map<AclBindingFilter, CompletionStage<AclDeleteResult>> deleteAcls(Optional<KafkaPrincipal> callingPrincipal, Scope scope, List<AclBindingFilter> aclBindingFilters, Predicate<ResourcePattern> resourceAccess) {
        throw new UnsupportedOperationException();
    }

    public void startWriter(int i) {
    }

    public void stopWriter(Integer integer) {
    }

    public boolean ready() {
        return true;
    }
}

