/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.kafka;

import io.confluent.rbacdb.orm.RbacOrmService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;

class DbRequestMetrics {
    final Metrics metrics;
    final String metricGroupName;
    private final Sensor requests;
    private final Sensor requestErrors;
    final List<Sensor> sensors = new ArrayList<Sensor>();
    final List<MetricName> metricNames = new ArrayList<MetricName>();

    DbRequestMetrics(Metrics metrics, String metricGrpPrefix, ThreadPoolExecutor executor, RbacOrmService dbService) {
        this.metrics = metrics;
        this.metricGroupName = metricGrpPrefix + "-metrics";
        String requestQueueSizeName = "request-queue-size";
        MetricName requestQueueSizeMetricName = metrics.metricName(requestQueueSizeName, this.metricGroupName, "The number of requests in the " + metricGrpPrefix + " thread pool executor queue.", Collections.emptyMap());
        metrics.addMetric(requestQueueSizeMetricName, (config, now) -> executor.getQueue().size());
        this.metricNames.add(requestQueueSizeMetricName);
        String activeTaskCountName = "active-task-count";
        MetricName activeTaskCountMetricName = metrics.metricName(activeTaskCountName, this.metricGroupName, metricGrpPrefix + " thread pool active task count.", Collections.emptyMap());
        Gauge activeTaskCount = (config, now) -> executor.getActiveCount();
        metrics.addMetric(activeTaskCountMetricName, (MetricValueProvider)activeTaskCount);
        this.metricNames.add(activeTaskCountMetricName);
        String threadPoolUsageName = "thread-pool-usage";
        MetricName threadPoolUsageMetricName = metrics.metricName(threadPoolUsageName, this.metricGroupName, metricGrpPrefix + " thread pool usage.", Collections.emptyMap());
        Gauge threadPoolUsage = (config, now) -> (double)executor.getActiveCount() / (double)executor.getMaximumPoolSize();
        metrics.addMetric(threadPoolUsageMetricName, (MetricValueProvider)threadPoolUsage);
        this.metricNames.add(threadPoolUsageMetricName);
        String requestsSensor = metricGrpPrefix + "-requests-sensor";
        String requestRate = "request-rate";
        this.requests = this.sensor(requestsSensor);
        MetricName requestRateMetricName = metrics.metricName(requestRate, this.metricGroupName, "The number of DB requests per second.");
        this.requests.add(requestRateMetricName, (MeasurableStat)new Rate());
        String errorSensor = metricGrpPrefix + "-request-errors-sensor";
        String errorRate = "request-error-rate";
        this.requestErrors = this.sensor(errorSensor);
        MetricName errorRateMetricName = metrics.metricName(errorRate, this.metricGroupName, "The number of request errors per second.");
        this.requestErrors.add(errorRateMetricName, (MeasurableStat)new Rate());
        String connectionQueueSizeName = "db-connection-queue-size";
        MetricName connectionQueueSizeMetricName = metrics.metricName(connectionQueueSizeName, this.metricGroupName, "The number of threads waiting in the " + metricGrpPrefix + " db connection pool queue.", Collections.emptyMap());
        metrics.addMetric(connectionQueueSizeMetricName, (config, now) -> dbService.getThreadsAwaitingConnection());
        this.metricNames.add(connectionQueueSizeMetricName);
        String activeConnectionCountName = "active-db-connection-count";
        MetricName activeConnectionCountMetricName = metrics.metricName(activeConnectionCountName, this.metricGroupName, metricGrpPrefix + " db connection pool active connection count.", Collections.emptyMap());
        Gauge activeConnectionCount = (config, now) -> dbService.getActiveConnections();
        metrics.addMetric(activeConnectionCountMetricName, (MetricValueProvider)activeConnectionCount);
        this.metricNames.add(activeConnectionCountMetricName);
        String connectionPoolUsageName = "db-connection-pool-usage";
        MetricName connectionPoolUsageMetricName = metrics.metricName(connectionPoolUsageName, this.metricGroupName, metricGrpPrefix + " db connection pool usage.", Collections.emptyMap());
        Gauge connectionPoolUsage = (config, now) -> (double)dbService.getActiveConnections() / (double)dbService.getTotalConnections();
        metrics.addMetric(connectionPoolUsageMetricName, (MetricValueProvider)connectionPoolUsage);
        this.metricNames.add(connectionPoolUsageMetricName);
    }

    public Sensor request() {
        return this.requests;
    }

    public Sensor requestError() {
        return this.requestErrors;
    }

    Sensor sensor(String name) {
        Sensor sensor = this.metrics.sensor(name);
        this.sensors.add(sensor);
        return sensor;
    }

    public void close() {
        for (Sensor sensor : this.sensors) {
            this.metrics.removeSensor(sensor.name());
        }
        for (MetricName metricName : this.metricNames) {
            this.metrics.removeMetric(metricName);
        }
    }

    public Runnable callRecordingError(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                this.requestError().record();
                throw exception;
            }
        };
    }
}

