/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.orm;

import com.google.common.annotations.VisibleForTesting;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import io.confluent.rbacdb.jooq.Sequences;
import io.confluent.rbacdb.jooq.Tables;
import io.confluent.rbacdb.jooq.tables.records.RoleBindingRecord;
import io.confluent.rbacdb.orm.ExtractorPublisherStateData;
import io.confluent.rbacdb.orm.RbacOrmService;
import io.confluent.rbacdb.orm.UpdatedRoleBindings;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.hashids.Hashids;
import org.jooq.Allow;
import org.jooq.CommonTableExpression;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.JSONB;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Record1;
import org.jooq.Record10;
import org.jooq.Record3;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacOrmDbService
implements RbacOrmService,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(RbacOrmDbService.class);
    private final HikariDataSource dataSource;
    private final HikariPoolMXBean poolProxy;
    private final Hashids hashids;
    private final RbacRoles rbacRoles;
    private final boolean skipHealthcheck;
    private final Select<Record1<Integer>> writePrivilegeCheckQuery;

    @Allow.PlainSQL
    private Select<Record1<Integer>> createWritePrivilegeCheckQuery(String userName) {
        DSLContext dsl = this.getDSLContext();
        return dsl.select((SelectField)DSL.count()).from("information_schema.role_table_grants").where(DSL.field((String)"grantee").eq((Object)userName)).and(DSL.field((String)"table_name").eq((Object)"role_binding")).and(DSL.field((String)"privilege_type").in(new Object[]{"INSERT", "UPDATE"}));
    }

    public RbacOrmDbService(RbacRoles rbacRoles, String dbUrl, String userName, String password, boolean skipHealthcheck, int connectionPoolSize) throws MalformedObjectNameException {
        this.rbacRoles = rbacRoles;
        this.skipHealthcheck = skipHealthcheck;
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(dbUrl);
        config.setUsername(userName);
        config.setPassword(password);
        config.setMaximumPoolSize(connectionPoolSize);
        config.setRegisterMbeans(true);
        this.dataSource = new HikariDataSource(config);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + this.dataSource.getPoolName() + ")");
        this.poolProxy = JMX.newMXBeanProxy(server, poolName, HikariPoolMXBean.class);
        this.writePrivilegeCheckQuery = this.createWritePrivilegeCheckQuery(userName);
        if (!skipHealthcheck) {
            log.info("Connecting to DB to run healthcheck...");
            this.doHealthCheck();
            log.info("DB healthcheck passed");
        } else {
            log.warn("WARNING: Skipping DB healthcheck!!!");
        }
        this.hashids = new Hashids("SALT for ConfluentRBAC rolebinding IDs");
    }

    public RbacOrmDbService(String dbUrl, String userName, String password, int connectionPoolSize) throws MalformedObjectNameException {
        this(RbacRoles.loadDefaultPolicy((boolean)true), dbUrl, userName, password, false, connectionPoolSize);
    }

    public RbacOrmDbService(String dbUrl, String userName, String password, boolean skipHealthcheck, int connectionPoolSize) throws MalformedObjectNameException {
        this(RbacRoles.loadDefaultPolicy((boolean)true), dbUrl, userName, password, skipHealthcheck, connectionPoolSize);
    }

    private static <T> Condition isNullOrEq(Field<T> field, T value) {
        return value == null ? field.isNull() : field.eq(value);
    }

    private static <T> Condition isNullOrEq(Field<T> lhs, Field<T> rhs) {
        return lhs.isNull().and(rhs.isNull()).or(lhs.eq(rhs));
    }

    @Override
    public void close() throws Exception {
        this.dataSource.close();
    }

    protected DSLContext getDSLContext() {
        return DSL.using((DataSource)this.dataSource, (SQLDialect)SQLDialect.POSTGRES);
    }

    private void doHealthCheck() {
        DSLContext dsl = this.getDSLContext();
        int numRows = dsl.select(Tables.ROLE_BINDING.ID).from((TableLike)Tables.ROLE_BINDING).where(Tables.ROLE_BINDING.ORGANIZATION_ID.isNull()).limit(1).execute();
        if (numRows < 1) {
            throw new IllegalStateException("Admins missing from DB. Has the DB schema been applied?");
        }
        numRows = (Integer)dsl.fetchValue(this.writePrivilegeCheckQuery);
        if (numRows != 2) {
            throw new IllegalStateException("DB user doesn't have write privileges");
        }
    }

    @Override
    public void addRoleBinding(KafkaPrincipal callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, String reason) {
        DSLContext dsl = this.getDSLContext();
        Long seqId = (Long)dsl.nextval(Sequences.ROLE_BINDING_ID_SEQ);
        String id = "rb-" + this.hashids.encode(new long[]{seqId});
        ScopeElements scopeElements = new ScopeElements(scope);
        dsl.insertInto((Table)Tables.ROLE_BINDING).set(Tables.ROLE_BINDING.ID, (Object)id).set(Tables.ROLE_BINDING.USER_ID, (Object)targetPrincipal.getName()).set(Tables.ROLE_BINDING.ROLE_NAME, (Object)role).set(Tables.ROLE_BINDING.ORGANIZATION_ID, (Object)scopeElements.orgId).set(Tables.ROLE_BINDING.ACCOUNT_ID, (Object)scopeElements.accountId).set(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, (Object)scopeElements.cloudClusterId).set(Tables.ROLE_BINDING.CLUSTER_TYPE, (Object)scopeElements.clusterType).set(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, (Object)scopeElements.logicalClusterId).set(Tables.ROLE_BINDING.CREATED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.MODIFIED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.REASON, (Object)JSONB.valueOf((String)reason)).onDuplicateKeyIgnore().execute();
    }

    @Override
    public void removeRoleBinding(KafkaPrincipal callingPrincipal, KafkaPrincipal targetPrincipal, String role, Scope scope, String reason) {
        DSLContext dsl = this.getDSLContext();
        dsl.update((Table)Tables.ROLE_BINDING).set(Tables.ROLE_BINDING.DELETED, (Object)true).set(Tables.ROLE_BINDING.MODIFIED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.REASON, (Object)JSONB.valueOf((String)reason)).where(Tables.ROLE_BINDING.DELETED.eq((Object)false)).and(Tables.ROLE_BINDING.USER_ID.eq((Object)targetPrincipal.getName())).and(Tables.ROLE_BINDING.ROLE_NAME.eq((Object)role)).and(ScopeElements.getEnclosingScopesCondition(scope)).and(Tables.ROLE_BINDING.RESOURCE_TYPE.isNull()).execute();
    }

    @Override
    public void addResourceRoleBindings(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> newResources, String reason) {
        DSLContext dsl = this.getDSLContext();
        dsl.transaction(configuration -> {
            DSLContext transactionContext = DSL.using((Configuration)configuration);
            this.addResourceRoleBindings(transactionContext, callingPrincipal, principal, role, scope, newResources, reason);
        });
    }

    private void addResourceRoleBindings(DSLContext dsl, KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> newResources, String reason) {
        ScopeElements scopeElements = new ScopeElements(scope);
        for (ResourcePattern resourcePattern : newResources) {
            Long seqId = (Long)dsl.nextval(Sequences.ROLE_BINDING_ID_SEQ);
            String id = "rb-" + this.hashids.encode(new long[]{seqId});
            dsl.insertInto((Table)Tables.ROLE_BINDING).set(Tables.ROLE_BINDING.ID, (Object)id).set(Tables.ROLE_BINDING.USER_ID, (Object)principal.getName()).set(Tables.ROLE_BINDING.ROLE_NAME, (Object)role).set(Tables.ROLE_BINDING.ORGANIZATION_ID, (Object)scopeElements.orgId).set(Tables.ROLE_BINDING.ACCOUNT_ID, (Object)scopeElements.accountId).set(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, (Object)scopeElements.cloudClusterId).set(Tables.ROLE_BINDING.CLUSTER_TYPE, (Object)scopeElements.clusterType).set(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, (Object)scopeElements.logicalClusterId).set(Tables.ROLE_BINDING.CREATED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.MODIFIED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.RESOURCE_TYPE, (Object)resourcePattern.resourceType().name()).set(Tables.ROLE_BINDING.RESOURCE_NAME, (Object)resourcePattern.name()).set(Tables.ROLE_BINDING.PATTERN_TYPE, (Object)resourcePattern.patternType().name()).set(Tables.ROLE_BINDING.REASON, (Object)JSONB.valueOf((String)reason)).onDuplicateKeyIgnore().execute();
        }
    }

    private List<String> filteredRoleBindingIds(DSLContext dsl, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePatternFilter> deleteFilters, boolean keepMatched) {
        Result result = dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)Tables.ROLE_BINDING).where(Tables.ROLE_BINDING.DELETED.eq((Object)false)).and(Tables.ROLE_BINDING.USER_ID.eq((Object)principal.getName())).and(Tables.ROLE_BINDING.ROLE_NAME.eq((Object)role)).and(ScopeElements.getEnclosingScopesCondition(scope)).fetch();
        return result.stream().filter(record -> {
            ResourcePattern pattern = new ResourcePattern((String)record.getValue(Tables.ROLE_BINDING.RESOURCE_TYPE), (String)record.getValue(Tables.ROLE_BINDING.RESOURCE_NAME), PatternType.fromString((String)((String)record.getValue(Tables.ROLE_BINDING.PATTERN_TYPE))));
            return keepMatched == deleteFilters.stream().anyMatch(filter -> filter.matches(pattern));
        }).map(record -> (String)record.getValue(Tables.ROLE_BINDING.ID)).collect(Collectors.toList());
    }

    private void deleteRoleBindingsById(DSLContext dsl, KafkaPrincipal callingPrincipal, Collection<String> ids, String reason) {
        dsl.update((Table)Tables.ROLE_BINDING).set(Tables.ROLE_BINDING.DELETED, (Object)true).set(Tables.ROLE_BINDING.MODIFIED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.REASON, (Object)JSONB.valueOf((String)reason)).where(Tables.ROLE_BINDING.ID.in(ids)).execute();
    }

    @Allow.PlainSQL
    private void lockRoleBindingTable(DSLContext transactionContext) {
        transactionContext.execute("LOCK TABLE " + (Object)((Object)Tables.ROLE_BINDING) + " IN SHARE MODE");
    }

    @Override
    public void removeResourceRoleBindings(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePatternFilter> deleteFilters, String reason) {
        DSLContext dsl = this.getDSLContext();
        dsl.transaction(configuration -> {
            DSLContext transactionContext = DSL.using((Configuration)configuration);
            this.lockRoleBindingTable(transactionContext);
            List<String> idsToDelete = this.filteredRoleBindingIds(transactionContext, principal, role, scope, deleteFilters, true);
            this.deleteRoleBindingsById(transactionContext, callingPrincipal, idsToDelete, reason);
        });
    }

    @Override
    public void replaceResourceRoleBindings(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> resources, String reason) {
        DSLContext dsl = this.getDSLContext();
        dsl.transaction(configuration -> {
            DSLContext transactionContext = DSL.using((Configuration)configuration);
            this.lockRoleBindingTable(transactionContext);
            List<ResourcePatternFilter> keepFilters = resources.stream().map(ResourcePattern::toFilter).collect(Collectors.toList());
            List<String> idsToDelete = this.filteredRoleBindingIds(transactionContext, principal, role, scope, keepFilters, false);
            this.deleteRoleBindingsById(transactionContext, callingPrincipal, idsToDelete, reason);
            this.addResourceRoleBindings(transactionContext, callingPrincipal, principal, role, scope, resources, reason);
        });
    }

    private void removeAllRoleBindingsWhere(KafkaPrincipal callingPrincipal, Condition whereCondition, String reason) {
        DSLContext dsl = this.getDSLContext();
        dsl.update((Table)Tables.ROLE_BINDING).set(Tables.ROLE_BINDING.DELETED, (Object)true).set(Tables.ROLE_BINDING.MODIFIED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.REASON, (Object)JSONB.valueOf((String)reason)).where(whereCondition.and(Tables.ROLE_BINDING.DELETED.eq((Object)false))).execute();
    }

    @Override
    public void removeAllRoleBindingsForPrincipal(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String reason) {
        this.removeAllRoleBindingsWhere(callingPrincipal, Tables.ROLE_BINDING.USER_ID.eq((Object)principal.getName()), reason);
    }

    @Override
    public void removeAllRoleBindingsForScope(KafkaPrincipal callingPrincipal, Scope scope, String reason) {
        Objects.requireNonNull(new ScopeElements((Scope)scope).orgId);
        this.removeAllRoleBindingsWhere(callingPrincipal, ScopeElements.getEnclosedScopesCondition(scope), reason);
    }

    @Override
    public void duplicateRoleBindingsForOrganization(KafkaPrincipal callingPrincipal, String sourceOrgId, String destinationOrgId, String reason) {
        Objects.requireNonNull(sourceOrgId);
        Objects.requireNonNull(destinationOrgId);
        DSLContext dsl = this.getDSLContext();
        dsl.transaction(configuration -> {
            DSLContext transactionContext = DSL.using((Configuration)configuration);
            this.lockRoleBindingTable(transactionContext);
            Result roleBindings = transactionContext.select(Tables.ROLE_BINDING.USER_ID, Tables.ROLE_BINDING.ROLE_NAME, Tables.ROLE_BINDING.ACCOUNT_ID, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, Tables.ROLE_BINDING.CLUSTER_TYPE, Tables.ROLE_BINDING.RESOURCE_TYPE, Tables.ROLE_BINDING.RESOURCE_NAME, Tables.ROLE_BINDING.PATTERN_TYPE).from((TableLike)Tables.ROLE_BINDING).where(Tables.ROLE_BINDING.ORGANIZATION_ID.eq((Object)sourceOrgId).and(Tables.ROLE_BINDING.DELETED.eq((Object)false))).orderBy(Tables.ROLE_BINDING.LAST_CHANGE_ID).fetch();
            roleBindings.forEach(record -> {
                Long seqId = (Long)transactionContext.nextval(Sequences.ROLE_BINDING_ID_SEQ);
                String id = "rb-" + this.hashids.encode(new long[]{seqId});
                transactionContext.insertInto((Table)Tables.ROLE_BINDING).set(Tables.ROLE_BINDING.ID, (Object)id).set(Tables.ROLE_BINDING.USER_ID, record.get(Tables.ROLE_BINDING.USER_ID)).set(Tables.ROLE_BINDING.ROLE_NAME, record.get(Tables.ROLE_BINDING.ROLE_NAME)).set(Tables.ROLE_BINDING.ORGANIZATION_ID, (Object)destinationOrgId).set(Tables.ROLE_BINDING.ACCOUNT_ID, record.get(Tables.ROLE_BINDING.ACCOUNT_ID)).set(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, record.get(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID)).set(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, record.get(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID)).set(Tables.ROLE_BINDING.CLUSTER_TYPE, record.get(Tables.ROLE_BINDING.CLUSTER_TYPE)).set(Tables.ROLE_BINDING.RESOURCE_TYPE, record.get(Tables.ROLE_BINDING.RESOURCE_TYPE)).set(Tables.ROLE_BINDING.RESOURCE_NAME, record.get(Tables.ROLE_BINDING.RESOURCE_NAME)).set(Tables.ROLE_BINDING.PATTERN_TYPE, record.get(Tables.ROLE_BINDING.PATTERN_TYPE)).set(Tables.ROLE_BINDING.CREATED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.MODIFIED_BY, (Object)callingPrincipal.getName()).set(Tables.ROLE_BINDING.REASON, (Object)JSONB.valueOf((String)reason)).onDuplicateKeyIgnore().execute();
            });
        });
    }

    private Scope getScopeFromRecord(Record record) {
        return ScopeElements.getScope((String)record.getValue(Tables.ROLE_BINDING.ORGANIZATION_ID), (String)record.getValue(Tables.ROLE_BINDING.ACCOUNT_ID), (String)record.getValue(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID), (String)record.getValue(Tables.ROLE_BINDING.CLUSTER_TYPE), (String)record.getValue(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID));
    }

    private RoleBinding getRoleBindingFromRecord(Record record) {
        String[][] resourcePatterns;
        KafkaPrincipal principal = new KafkaPrincipal("User", (String)record.getValue(Tables.ROLE_BINDING.USER_ID));
        Scope scope = this.getScopeFromRecord(record);
        ArrayList<ResourcePattern> resources = new ArrayList<ResourcePattern>();
        for (String[] resourcePattern : resourcePatterns = (String[][])record.getValue("resource_patterns")) {
            String resourceType = resourcePattern[0];
            if (resourceType == null) continue;
            String resourceName = resourcePattern[1];
            String patternType = resourcePattern[2];
            resources.add(new ResourcePattern(resourceType, resourceName, PatternType.fromString((String)patternType)));
        }
        return new RoleBinding(principal, (String)record.getValue(Tables.ROLE_BINDING.ROLE_NAME), scope, resources);
    }

    private Set<RoleBinding> fetchRoleBindings(Condition whereCondition) {
        DSLContext dsl = this.getDSLContext();
        Result result = dsl.select(Tables.ROLE_BINDING.USER_ID, Tables.ROLE_BINDING.ROLE_NAME, Tables.ROLE_BINDING.ORGANIZATION_ID, Tables.ROLE_BINDING.ACCOUNT_ID, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, Tables.ROLE_BINDING.CLUSTER_TYPE, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, (SelectField)DSL.arrayAgg((Field)DSL.array((Field[])new Field[]{Tables.ROLE_BINDING.RESOURCE_TYPE, Tables.ROLE_BINDING.RESOURCE_NAME, Tables.ROLE_BINDING.PATTERN_TYPE})).as("resource_patterns")).from((TableLike)Tables.ROLE_BINDING).where(whereCondition).groupBy(new GroupField[]{Tables.ROLE_BINDING.USER_ID, Tables.ROLE_BINDING.ROLE_NAME, Tables.ROLE_BINDING.ORGANIZATION_ID, Tables.ROLE_BINDING.ACCOUNT_ID, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, Tables.ROLE_BINDING.CLUSTER_TYPE, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID}).fetch();
        HashSet<RoleBinding> roleBindings = new HashSet<RoleBinding>();
        for (Record r : result) {
            roleBindings.add(this.getRoleBindingFromRecord(r));
        }
        return roleBindings;
    }

    private Set<RoleBinding> fetchNonDeletedRoleBindings(Condition whereCondition) {
        return this.fetchRoleBindings(whereCondition.and(Tables.ROLE_BINDING.DELETED.eq((Object)false)));
    }

    @Override
    public Set<RoleBinding> rbacRoleBindings(Set<Scope> targetScopes) {
        return this.rbacRoleBindings(null, targetScopes);
    }

    @Override
    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal) {
        Condition where = Tables.ROLE_BINDING.USER_ID.equal((Object)principal.getName());
        return this.fetchNonDeletedRoleBindings(where);
    }

    @Override
    public Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal, Set<Scope> scopes) {
        if (scopes.isEmpty()) {
            return Collections.emptySet();
        }
        Condition where = scopes.stream().map(ScopeElements::getEnclosingScopesCondition).reduce(Condition::or).get();
        if (principal != null) {
            where = where.and(Tables.ROLE_BINDING.USER_ID.eq((Object)principal.getName()));
        }
        return this.fetchNonDeletedRoleBindings(where);
    }

    @Override
    public Set<RoleBinding> rbacRoleBindings(RoleBindingFilter filter) {
        Objects.requireNonNull(filter.scope(), "Scope can not be null in RoleBindingFilter");
        Set<RoleBinding> roleBindings = this.rbacRoleBindings(Collections.singleton(filter.scope()));
        HashSet<RoleBinding> bindings = new HashSet<RoleBinding>();
        roleBindings.forEach(binding -> {
            RoleBinding matching = filter.matchingBinding(binding, this.rbacRoles.role(binding.role()).bindWithResource());
            if (matching != null) {
                bindings.add(matching);
            }
        });
        return bindings;
    }

    @Override
    public List<RoleBindingRecord> rbacRoleBindingRecordsIncludingDeleted(String reason) {
        DSLContext dsl = this.getDSLContext();
        return dsl.selectFrom((Table)Tables.ROLE_BINDING).where(Tables.ROLE_BINDING.REASON.eq((Object)JSONB.valueOf((String)reason))).orderBy(Tables.ROLE_BINDING.ID).fetch();
    }

    public long maxRoleBindingLastChangeId() {
        DSLContext dsl = this.getDSLContext();
        Long result = (Long)dsl.select((SelectField)DSL.max(Tables.ROLE_BINDING.LAST_CHANGE_ID)).from((TableLike)Tables.ROLE_BINDING).fetchOne(0, Long.class);
        return result == null ? -1L : result;
    }

    protected long maxPublishedRoleBindingLastChangeId(DSLContext dsl) {
        Long result = (Long)dsl.select((SelectField)DSL.max(Tables.EXTRACTOR_PUBLISHER_STATE.ROLE_BINDING_LAST_CHANGE_ID)).from((TableLike)Tables.EXTRACTOR_PUBLISHER_STATE).fetchOne(0, Long.class);
        return result == null ? -1L : result;
    }

    protected ExtractorPublisherStateData publisherStateRecordForMaxPublishedLastChangeId(DSLContext dsl) {
        ExtractorPublisherStateData data = new ExtractorPublisherStateData();
        Record3 result = (Record3)dsl.select(Tables.EXTRACTOR_PUBLISHER_STATE.EVENTS_KAFKA_MESSAGE_SEQUENCE_ID, Tables.EXTRACTOR_PUBLISHER_STATE.ROLE_BINDING_LAST_CHANGE_ID, Tables.EXTRACTOR_PUBLISHER_STATE.CREATED).from((TableLike)Tables.EXTRACTOR_PUBLISHER_STATE).orderBy((OrderField)Tables.EXTRACTOR_PUBLISHER_STATE.ROLE_BINDING_LAST_CHANGE_ID.desc(), (OrderField)Tables.EXTRACTOR_PUBLISHER_STATE.EVENTS_KAFKA_MESSAGE_SEQUENCE_ID.desc()).limit(1).fetchOne();
        if (result != null) {
            data.setEventsKafkaMessageSequenceId((Long)result.getValue(Tables.EXTRACTOR_PUBLISHER_STATE.EVENTS_KAFKA_MESSAGE_SEQUENCE_ID));
            data.setRoleBindingLastChangeId((Long)result.getValue(Tables.EXTRACTOR_PUBLISHER_STATE.ROLE_BINDING_LAST_CHANGE_ID));
            data.setTimeCreated((LocalDateTime)result.getValue(Tables.EXTRACTOR_PUBLISHER_STATE.CREATED));
        }
        return data;
    }

    protected List<Long> nextEventsKafkaMessageSequenceIds(DSLContext dsl, int n) {
        return dsl.select((SelectField)Sequences.EXTRACTOR_EVENTS_KAFKA_MESSAGE_SEQUENCE_ID.nextval()).from((TableLike)DSL.generateSeries((int)1, (int)n)).fetch(0, Long.class);
    }

    protected void recordSuccessfulPublish(DSLContext dsl, long maxEventsKafkaMessageSequenceId, long maxRoleBindingLastChangeId) {
        dsl.insertInto((Table)Tables.EXTRACTOR_PUBLISHER_STATE).set(Tables.EXTRACTOR_PUBLISHER_STATE.EVENTS_KAFKA_MESSAGE_SEQUENCE_ID, (Object)maxEventsKafkaMessageSequenceId).set(Tables.EXTRACTOR_PUBLISHER_STATE.ROLE_BINDING_LAST_CHANGE_ID, (Object)maxRoleBindingLastChangeId).execute();
    }

    public long roleBindingLastChangeIdForMessageSequenceId(long messageSequenceId) {
        DSLContext dsl = this.getDSLContext();
        Long result = (Long)dsl.select((SelectField)DSL.max(Tables.EXTRACTOR_PUBLISHER_STATE.ROLE_BINDING_LAST_CHANGE_ID)).from((TableLike)Tables.EXTRACTOR_PUBLISHER_STATE).where(Tables.EXTRACTOR_PUBLISHER_STATE.EVENTS_KAFKA_MESSAGE_SEQUENCE_ID.le((Object)messageSequenceId)).fetchOne(0, Long.class);
        return result == null ? -1L : result;
    }

    protected UpdatedRoleBindings recentlyUpdatedRoleBindings(DSLContext dsl, long sinceLastChangeId) {
        Condition whereCondition = Tables.ROLE_BINDING.LAST_CHANGE_ID.greaterThan((Object)sinceLastChangeId);
        return this.queryUpdatedRoleBindings(dsl, whereCondition);
    }

    protected UpdatedRoleBindings queryUpdatedRoleBindings(DSLContext dsl, String orgId, long endLastChangeId) {
        Condition whereCondition = Tables.ROLE_BINDING.ORGANIZATION_ID.equal((Object)orgId).and(Tables.ROLE_BINDING.LAST_CHANGE_ID.between((Object)0L, (Object)endLastChangeId));
        return this.queryUpdatedRoleBindings(dsl, whereCondition);
    }

    protected UpdatedRoleBindings queryUpdatedRoleBindings(DSLContext dsl, Condition whereCondition) {
        CommonTableExpression recentTableExpression = DSL.name((String)"recent").as((Select)DSL.select(Tables.ROLE_BINDING.USER_ID, Tables.ROLE_BINDING.ROLE_NAME, Tables.ROLE_BINDING.ORGANIZATION_ID, Tables.ROLE_BINDING.ACCOUNT_ID, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, Tables.ROLE_BINDING.CLUSTER_TYPE, (SelectField)DSL.max(Tables.ROLE_BINDING.LAST_CHANGE_ID).as("last_change_id")).from((TableLike)Tables.ROLE_BINDING).where(whereCondition).groupBy(new GroupField[]{Tables.ROLE_BINDING.USER_ID, Tables.ROLE_BINDING.ROLE_NAME, Tables.ROLE_BINDING.ORGANIZATION_ID, Tables.ROLE_BINDING.ACCOUNT_ID, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, Tables.ROLE_BINDING.CLUSTER_TYPE}));
        Field recentUserId = recentTableExpression.field("user_id", String.class);
        Field recentRoleName = recentTableExpression.field("role_name", String.class);
        Field recentOrganizationId = recentTableExpression.field("organization_id", String.class);
        Field recentAccountId = recentTableExpression.field("account_id", String.class);
        Field recentCloudClusterId = recentTableExpression.field("cloud_cluster_id", String.class);
        Field recentLogicalClusterId = recentTableExpression.field("logical_cluster_id", String.class);
        Field recentClusterType = recentTableExpression.field("cluster_type", String.class);
        Field recentLastChangeId = recentTableExpression.field("last_change_id", Long.class);
        Result result = dsl.with(new CommonTableExpression[]{recentTableExpression}).select((SelectField)recentUserId, (SelectField)recentRoleName, (SelectField)recentOrganizationId, (SelectField)recentAccountId, (SelectField)recentCloudClusterId, (SelectField)recentLogicalClusterId, (SelectField)recentClusterType, (SelectField)recentLastChangeId, (SelectField)DSL.arrayAgg((Field)DSL.array((Field[])new Field[]{Tables.ROLE_BINDING.RESOURCE_TYPE, Tables.ROLE_BINDING.RESOURCE_NAME, Tables.ROLE_BINDING.PATTERN_TYPE})).as("resource_patterns"), (SelectField)DSL.coalesce((Field)DSL.boolAnd(Tables.ROLE_BINDING.DELETED), (Object)true).as("deleted")).from((TableLike)recentTableExpression).leftJoin((TableLike)Tables.ROLE_BINDING).on(Tables.ROLE_BINDING.USER_ID.eq(recentUserId)).and(RbacOrmDbService.isNullOrEq(recentOrganizationId, Tables.ROLE_BINDING.ORGANIZATION_ID)).and(RbacOrmDbService.isNullOrEq(recentAccountId, Tables.ROLE_BINDING.ACCOUNT_ID)).and(RbacOrmDbService.isNullOrEq(recentCloudClusterId, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID)).and(RbacOrmDbService.isNullOrEq(recentLogicalClusterId, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID)).and(Tables.ROLE_BINDING.DELETED.eq((Object)false)).groupBy(new GroupField[]{recentUserId, recentRoleName, recentOrganizationId, recentAccountId, recentCloudClusterId, recentLogicalClusterId, recentClusterType, recentLastChangeId}).orderBy((OrderField)recentLastChangeId).fetch();
        ArrayList<RoleBinding> roleBindings = new ArrayList<RoleBinding>();
        ArrayList<Boolean> deleted = new ArrayList<Boolean>();
        long lastChangeId = -1L;
        for (Record r : result) {
            roleBindings.add(this.getRoleBindingFromRecord(r));
            deleted.add((Boolean)r.getValue("deleted", Boolean.class));
        }
        List<Long> messageSequenceIds = this.nextEventsKafkaMessageSequenceIds(dsl, roleBindings.size());
        if (!result.isEmpty()) {
            lastChangeId = (Long)((Record10)result.get(result.size() - 1)).getValue(recentLastChangeId);
        }
        return new UpdatedRoleBindings(roleBindings, deleted, messageSequenceIds, lastChangeId);
    }

    @Allow.PlainSQL
    private void lockExtractorPublisherStateTable(DSLContext transactionContext) {
        transactionContext.execute("LOCK TABLE " + (Object)((Object)Tables.EXTRACTOR_PUBLISHER_STATE) + " IN SHARE ROW EXCLUSIVE MODE");
    }

    public int publishRecentlyUpdatedRoleBindings(Function<UpdatedRoleBindings, Integer> publisher) {
        DSLContext dsl = this.getDSLContext();
        AtomicInteger count = new AtomicInteger(0);
        dsl.transaction(configuration -> {
            DSLContext transactionContext = DSL.using((Configuration)configuration);
            this.lockExtractorPublisherStateTable(transactionContext);
            UpdatedRoleBindings unpublished = this.recentlyUpdatedRoleBindings(transactionContext, this.maxPublishedRoleBindingLastChangeId(transactionContext));
            if (unpublished.roleBindings.isEmpty()) {
                return;
            }
            int published = (Integer)publisher.apply(unpublished);
            count.set(published);
            if (published != unpublished.roleBindings.size()) {
                log.warn("Tried to publish {} role bindings, but actually published {}", (Object)unpublished.roleBindings.size(), (Object)published);
            } else {
                long lastSequenceId = unpublished.messageSequenceIds.get(unpublished.messageSequenceIds.size() - 1);
                this.recordSuccessfulPublish(transactionContext, lastSequenceId, unpublished.lastChangeId);
            }
        });
        return count.get();
    }

    public ExtractorPublisherStateData publishUpdatedRoleBindingsForOrg(Function<UpdatedRoleBindings, Integer> publisher, String orgId) {
        DSLContext dsl = this.getDSLContext();
        AtomicReference<ExtractorPublisherStateData> extractorState = new AtomicReference<ExtractorPublisherStateData>(new ExtractorPublisherStateData());
        dsl.transaction(configuration -> {
            DSLContext transactionContext = DSL.using((Configuration)configuration);
            this.lockExtractorPublisherStateTable(transactionContext);
            ExtractorPublisherStateData record = this.publisherStateRecordForMaxPublishedLastChangeId(transactionContext);
            UpdatedRoleBindings toPublish = this.queryUpdatedRoleBindings(transactionContext, orgId, record.getRoleBindingLastChangeId());
            if (toPublish.roleBindings.isEmpty()) {
                return;
            }
            int published = (Integer)publisher.apply(toPublish);
            record.setTotalRoleBindingRecordsPublished(published);
            extractorState.set(record);
            if (published != toPublish.roleBindings.size()) {
                log.warn("Tried to publish {} role bindings, but actually published {}", (Object)toPublish.roleBindings.size(), (Object)published);
            } else {
                long lastSequenceId = toPublish.messageSequenceIds.get(toPublish.messageSequenceIds.size() - 1);
                this.recordSuccessfulPublish(transactionContext, lastSequenceId, toPublish.lastChangeId);
            }
        });
        return extractorState.get();
    }

    @Override
    public Collection<ResourcePattern> rbacResources(KafkaPrincipal principal, String role, Scope scope) {
        Condition where = Tables.ROLE_BINDING.USER_ID.eq((Object)principal.getName()).and(Tables.ROLE_BINDING.ROLE_NAME.eq((Object)role)).and(ScopeElements.getEnclosingScopesCondition(scope));
        return this.fetchNonDeletedRoleBindings(where).stream().flatMap(rb -> rb.resources().stream()).collect(Collectors.toList());
    }

    @Override
    public Set<Scope> knownScopes() {
        DSLContext dsl = this.getDSLContext();
        Result result = dsl.selectDistinct(Tables.ROLE_BINDING.ORGANIZATION_ID, Tables.ROLE_BINDING.ACCOUNT_ID, Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, Tables.ROLE_BINDING.CLUSTER_TYPE, Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID).from((TableLike)Tables.ROLE_BINDING).where(Tables.ROLE_BINDING.DELETED.eq((Object)false)).fetch();
        return result.stream().map(this::getScopeFromRecord).collect(Collectors.toSet());
    }

    @VisibleForTesting
    public Result<Record> allRoleBindingRecords() {
        DSLContext dsl = this.getDSLContext();
        return dsl.select(new SelectFieldOrAsterisk[0]).from((TableLike)Tables.ROLE_BINDING).orderBy(Tables.ROLE_BINDING.MODIFIED, Tables.ROLE_BINDING.DELETED).fetch();
    }

    @Override
    public int getActiveConnections() {
        return this.poolProxy.getActiveConnections();
    }

    @Override
    public int getTotalConnections() {
        return this.poolProxy.getTotalConnections();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.poolProxy.getThreadsAwaitingConnection();
    }

    @Override
    public void healthcheck() {
        if (!this.skipHealthcheck) {
            this.doHealthCheck();
        }
    }

    private static class ScopeElements {
        String orgId;
        String accountId;
        String cloudClusterId;
        String clusterType;
        String logicalClusterId;

        public ScopeElements(Scope scope) {
            List path = scope.path();
            if (path.isEmpty()) {
                throw new IllegalArgumentException("Scope missing organization");
            }
            this.orgId = ((String)path.get(0)).replace("organization=", "");
            if (this.orgId.contains("=")) {
                throw new IllegalArgumentException("Unexpected scope path element: " + (String)path.get(0));
            }
            if (path.size() > 1) {
                this.accountId = ((String)scope.path().get(1)).replace("environment=", "");
                if (this.accountId.contains("=")) {
                    throw new IllegalArgumentException("Unexpected scope path element: " + (String)path.get(1));
                }
            }
            if (path.size() > 2) {
                this.cloudClusterId = ((String)scope.path().get(2)).replace("cloud-cluster=", "");
                if (this.cloudClusterId.contains("=")) {
                    throw new IllegalArgumentException("Unexpected scope path element: " + (String)path.get(2));
                }
                if (scope.clusters().size() == 2) {
                    HashMap clusters = new HashMap(scope.clusters());
                    if (clusters.remove("kafka-cluster") == null) {
                        throw new IllegalArgumentException("Scope clusters missing kafka-cluster");
                    }
                    this.clusterType = (String)clusters.keySet().iterator().next();
                    this.logicalClusterId = (String)clusters.get(this.clusterType);
                } else if (!scope.clusters().isEmpty()) {
                    this.clusterType = "kafka-cluster";
                    this.logicalClusterId = (String)scope.clusters().get("kafka-cluster");
                    if (this.logicalClusterId == null) {
                        throw new IllegalArgumentException("Scope clusters missing kafka-cluster");
                    }
                }
            } else if (!scope.clusters().isEmpty()) {
                throw new IllegalArgumentException("Scope with clusters missing cloud-cluster");
            }
            if (path.size() > 3) {
                throw new IllegalArgumentException("Too many elements in scope path: " + path);
            }
        }

        public static Scope getScope(String orgId, String accountId, String cloudClusterId, String clusterType, String logicalClusterId) {
            ArrayList<String> path = new ArrayList<String>();
            HashMap<String, String> clusters = new HashMap<String, String>();
            if (orgId != null) {
                path.add("organization=" + orgId);
            }
            if (accountId != null) {
                path.add("environment=" + accountId);
            }
            if (cloudClusterId != null) {
                path.add("cloud-cluster=" + cloudClusterId);
            }
            if (clusterType != null) {
                clusters.put("kafka-cluster", cloudClusterId);
                if (!clusterType.equals("kafka-cluster")) {
                    clusters.put(clusterType, logicalClusterId);
                }
            }
            return new Scope(path, clusters);
        }

        public static Condition getEnclosingScopesCondition(Scope scope) {
            ScopeElements elements = new ScopeElements(scope);
            return RbacOrmDbService.isNullOrEq(Tables.ROLE_BINDING.ORGANIZATION_ID, elements.orgId).and(RbacOrmDbService.isNullOrEq(Tables.ROLE_BINDING.ACCOUNT_ID, elements.accountId)).and(RbacOrmDbService.isNullOrEq(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID, elements.cloudClusterId)).and(RbacOrmDbService.isNullOrEq(Tables.ROLE_BINDING.CLUSTER_TYPE, elements.clusterType)).and(RbacOrmDbService.isNullOrEq(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID, elements.logicalClusterId));
        }

        public static Condition getEnclosedScopesCondition(Scope scope) {
            ScopeElements elements = new ScopeElements(scope);
            Condition condition = Tables.ROLE_BINDING.ORGANIZATION_ID.eq((Object)elements.orgId);
            if (elements.accountId != null) {
                condition = condition.and(Tables.ROLE_BINDING.ACCOUNT_ID.eq((Object)elements.accountId));
                if (elements.cloudClusterId != null) {
                    condition = condition.and(Tables.ROLE_BINDING.CLOUD_CLUSTER_ID.eq((Object)elements.cloudClusterId));
                    if (elements.logicalClusterId != null && elements.clusterType != null) {
                        condition = condition.and(Tables.ROLE_BINDING.CLUSTER_TYPE.eq((Object)elements.clusterType)).and(Tables.ROLE_BINDING.LOGICAL_CLUSTER_ID.eq((Object)elements.logicalClusterId));
                    }
                }
            }
            return condition;
        }
    }
}

