/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.orm;

import io.confluent.rbacdb.jooq.tables.records.RoleBindingRecord;
import io.confluent.rbacdb.orm.RbacOrmService;
import io.confluent.security.auth.store.cache.DefaultAuthCache;
import io.confluent.security.auth.store.data.AuthKey;
import io.confluent.security.auth.store.data.AuthValue;
import io.confluent.security.auth.store.data.RoleBindingKey;
import io.confluent.security.auth.store.data.RoleBindingValue;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RbacRoles;
import io.confluent.security.rbac.RoleBinding;
import io.confluent.security.rbac.RoleBindingFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class RbacOrmStubService
implements RbacOrmService {
    private final DefaultAuthCache authCache;

    public RbacOrmStubService() {
        this.authCache = new DefaultAuthCache(RbacRoles.loadDefaultPolicy((boolean)true), Scope.ROOT_SCOPE);
    }

    public RbacOrmStubService(RbacRoles rbacRoles, Scope rootScope) {
        this.authCache = new DefaultAuthCache(rbacRoles, rootScope);
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public synchronized void addRoleBinding(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, String reason) {
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        RoleBindingValue value = new RoleBindingValue(Collections.emptyList());
        this.authCache.put((AuthKey)key, (AuthValue)value);
    }

    @Override
    public synchronized void removeRoleBinding(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, String reason) {
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        this.authCache.remove((AuthKey)key);
    }

    @Override
    public synchronized void addResourceRoleBindings(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> newResources, String reason) {
        RoleBindingKey key = new RoleBindingKey(principal, role, scope);
        HashSet<ResourcePattern> updatedResources = new HashSet<ResourcePattern>();
        Collection<ResourcePattern> existingResources = this.rbacResources(principal, role, scope);
        if (existingResources != null) {
            updatedResources.addAll(existingResources);
        }
        updatedResources.addAll(newResources);
        RoleBindingValue newValue = new RoleBindingValue(updatedResources);
        this.authCache.put((AuthKey)key, (AuthValue)newValue);
    }

    @Override
    public synchronized void removeResourceRoleBindings(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePatternFilter> patternFilters, String reason) {
        Collection<ResourcePattern> existingResources = this.rbacResources(principal, role, scope);
        if (existingResources == null || existingResources.isEmpty()) {
            return;
        }
        Collection deleteResources = existingResources.stream().filter(resourcePattern -> patternFilters.stream().anyMatch(patternFilter -> patternFilter.matches(resourcePattern))).collect(Collectors.toList());
        HashSet<ResourcePattern> updatedResources = new HashSet<ResourcePattern>(existingResources);
        updatedResources.removeAll(deleteResources);
        if (!updatedResources.isEmpty()) {
            RoleBindingKey key = new RoleBindingKey(principal, role, scope);
            RoleBindingValue newValue = new RoleBindingValue(updatedResources);
            this.authCache.put((AuthKey)key, (AuthValue)newValue);
        } else {
            this.removeRoleBinding(callingPrincipal, principal, role, scope);
        }
    }

    @Override
    public synchronized void replaceResourceRoleBindings(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String role, Scope scope, Collection<ResourcePattern> resources, String reason) {
        this.removeRoleBinding(callingPrincipal, principal, role, scope);
        this.addResourceRoleBindings(callingPrincipal, principal, role, scope, resources);
    }

    @Override
    public void removeAllRoleBindingsForPrincipal(KafkaPrincipal callingPrincipal, KafkaPrincipal principal, String reason) {
        this.authCache.rbacRoleBindings(principal).forEach(roleBinding -> this.removeRoleBinding(callingPrincipal, principal, roleBinding.role(), roleBinding.scope(), reason));
    }

    @Override
    public void removeAllRoleBindingsForScope(KafkaPrincipal callingPrincipal, Scope scope, String reason) {
        this.authCache.rbacRoleBindings(scope).forEach(roleBinding -> this.removeRoleBinding(callingPrincipal, roleBinding.principal(), roleBinding.role(), roleBinding.scope(), reason));
    }

    @Override
    public void duplicateRoleBindingsForOrganization(KafkaPrincipal callingPrincipal, String sourceOrgId, String destinationOrgId, String reason) {
        Scope sourceScope = new Scope.Builder(new String[]{"organization=" + sourceOrgId}).build();
        Set enclosedScopes = this.authCache.knownScopes().stream().filter(arg_0 -> ((Scope)sourceScope).containsScope(arg_0)).collect(Collectors.toSet());
        this.authCache.rbacRoleBindings(enclosedScopes).forEach(roleBinding -> {
            ArrayList<String> paths = new ArrayList<String>(roleBinding.scope().path());
            paths.set(0, "organization=" + destinationOrgId);
            Scope.Builder builder = new Scope.Builder(new String[0]);
            paths.forEach(arg_0 -> ((Scope.Builder)builder).addPath(arg_0));
            roleBinding.scope().clusters().forEach((arg_0, arg_1) -> ((Scope.Builder)builder).withCluster(arg_0, arg_1));
            Scope destinationScope = builder.build();
            if (roleBinding.resources().isEmpty()) {
                this.addRoleBinding(callingPrincipal, roleBinding.principal(), roleBinding.role(), destinationScope, reason);
            } else {
                this.addResourceRoleBindings(callingPrincipal, roleBinding.principal(), roleBinding.role(), destinationScope, roleBinding.resources(), reason);
            }
        });
    }

    @Override
    public synchronized Set<RoleBinding> rbacRoleBindings(RoleBindingFilter filter) {
        return this.authCache.rbacRoleBindings(filter);
    }

    @Override
    public synchronized Set<RoleBinding> rbacRoleBindings(Set<Scope> targetScopes) {
        return this.authCache.rbacRoleBindings(targetScopes);
    }

    @Override
    public synchronized Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal) {
        return this.authCache.rbacRoleBindings(principal);
    }

    @Override
    public synchronized Set<RoleBinding> rbacRoleBindings(KafkaPrincipal principal, Set<Scope> scopes) {
        return this.authCache.rbacRoleBindings(principal, scopes);
    }

    @Override
    public List<RoleBindingRecord> rbacRoleBindingRecordsIncludingDeleted(String reason) {
        return Collections.emptyList();
    }

    @Override
    public synchronized Collection<ResourcePattern> rbacResources(KafkaPrincipal principal, String role, Scope scope) {
        RoleBindingValue assignment = (RoleBindingValue)this.authCache.get((AuthKey)new RoleBindingKey(principal, role, scope));
        return assignment == null ? null : assignment.resources();
    }

    @Override
    public synchronized Set<Scope> knownScopes() {
        return this.authCache.knownScopes();
    }

    @Override
    public int getActiveConnections() {
        return -1;
    }

    @Override
    public int getTotalConnections() {
        return -1;
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return -1;
    }

    @Override
    public void healthcheck() {
    }
}

