/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacdb.provider;

import io.confluent.rbacdb.config.DbAuthStoreConfig;
import io.confluent.rbacdb.exception.DbAuthStoreException;
import io.confluent.rbacdb.kafka.DbAuthStore;
import io.confluent.rbacdb.orm.RbacOrmDbService;
import io.confluent.rbacdb.orm.RbacOrmService;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.provider.ConfluentProvider;
import io.confluent.security.authorizer.Scope;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class ControlPlaneDBProvider
extends ConfluentProvider {
    public static final String PROVIDER_NAME = "CC_CONTROL_PLANE_MDS_DB";
    RbacOrmService ormService;

    public String providerName() {
        return PROVIDER_NAME;
    }

    protected AuthStore createAuthStore(Scope rootScope, ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> configs) {
        DbAuthStoreConfig authStoreConfig = new DbAuthStoreConfig(configs);
        String dbUrl = authStoreConfig.getString("confluent.metadata.server.db.url");
        String dbUser = authStoreConfig.getString("confluent.metadata.server.db.username");
        String dbPass = authStoreConfig.getPassword("confluent.metadata.server.db.password").value();
        if (dbUrl == null || dbUser == null || dbPass == null) {
            throw new DbAuthStoreException("Missing configuration for DB Auth Store");
        }
        int connectionPoolSize = authStoreConfig.getInt("confluent.metadata.server.db.connection.pool.size");
        boolean skipHealthcheck = authStoreConfig.getBoolean("confluent.metadata.server.db.skip.healthcheck");
        try {
            this.ormService = new RbacOrmDbService(dbUrl, dbUser, dbPass, skipHealthcheck, connectionPoolSize);
        }
        catch (Exception e) {
            throw new DbAuthStoreException("Unable to create RbacOrmDbService", e);
        }
        DbAuthStore authStore = new DbAuthStore(rootScope, authStoreConfig, this.ormService, serverInfo.metrics());
        authStore.configure(configs);
        return authStore;
    }

    public void close() {
        Utils.closeQuietly((AutoCloseable)this.ormService, (String)"RbacOrmDbService");
        super.close();
    }
}

