/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.rbac;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class RoleBinding {
    private final KafkaPrincipal principal;
    private final Collection<ResourcePattern> resources;
    private final String role;
    private final Scope scope;

    @JsonCreator
    public RoleBinding(@JsonProperty(value="principal") KafkaPrincipal principal, @JsonProperty(value="role") String role, @JsonProperty(value="scope") Scope scope, @JsonProperty(value="resources") Collection<ResourcePattern> resources) {
        this.principal = Objects.requireNonNull(principal, "principal must not be null");
        if (role == null || role.isEmpty()) {
            throw new IllegalArgumentException("Role must be non-empty for role binding");
        }
        this.role = role;
        if (scope == null) {
            throw new IllegalArgumentException("Scope must be non-empty for role binding");
        }
        this.scope = scope;
        this.resources = resources == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<ResourcePattern>(resources));
    }

    @JsonProperty
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @JsonProperty
    public String role() {
        return this.role;
    }

    @JsonProperty
    public Scope scope() {
        return this.scope;
    }

    @JsonProperty
    public Collection<ResourcePattern> resources() {
        return this.resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleBinding)) {
            return false;
        }
        RoleBinding that = (RoleBinding)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals(this.role, that.role) && Objects.equals(this.scope, that.scope) && Objects.equals(this.resources, that.resources);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.role, this.scope, this.resources);
    }

    public String toString() {
        return "RoleBinding(principal=" + String.valueOf(this.principal) + ", role='" + this.role + "', scope='" + String.valueOf(this.scope) + "', resources=" + String.valueOf(this.resources) + ")";
    }
}

