/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.utils.JsonMapper;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AuthorizeRequest {
    public final String userPrincipal;
    public final Set<String> groups;
    public final String host;
    public final List<Action> actions;

    public AuthorizeRequest(String userPrincipal, String host, List<Action> actions) {
        this(userPrincipal, null, host, actions);
    }

    @JsonCreator
    public AuthorizeRequest(@JsonProperty(value="userPrincipal") String userPrincipal, @JsonProperty(value="groups") Set<String> groups, @JsonProperty(value="host") String host, @JsonProperty(value="actions") List<Action> actions) {
        this.userPrincipal = userPrincipal;
        this.groups = groups;
        this.host = host;
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizeRequest that = (AuthorizeRequest)o;
        return Objects.equals(this.userPrincipal, that.userPrincipal) && Objects.equals(this.host, that.host) && Objects.equals(this.actions, that.actions);
    }

    public int hashCode() {
        return Objects.hash(this.userPrincipal, this.host, this.actions);
    }

    public String toString() {
        return "AuthorizeRequest{userPrincipal='" + this.userPrincipal + "', host='" + this.host + "', groups='" + String.valueOf(this.groups) + "', actions=" + String.valueOf(this.actions) + "}";
    }

    public String toJson() throws IOException {
        return JsonMapper.objectMapper().writeValueAsString((Object)this);
    }
}

