/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.metrics.MetricsContext;

public final class RestMetricsContext
implements MetricsContext {
    private final Map<String, String> contextLabels = new HashMap<String, String>();

    public RestMetricsContext(String namespace, Map<String, Object> config) {
        this.contextLabels.put("_namespace", namespace);
        config.forEach((key, value) -> this.contextLabels.put((String)key, value.toString()));
    }

    public void setLabel(String labelKey, String labelValue) {
        this.contextLabels.put(labelKey, labelValue);
    }

    public void setLabels(Map<String, String> labels) {
        labels.forEach(this::setLabel);
    }

    public String getLabel(String label) {
        return this.contextLabels.get(label);
    }

    public Map<String, String> contextLabels() {
        return Collections.unmodifiableMap(this.contextLabels);
    }
}

