/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFactoryPemHelper {
    public static final String FIPS_KEYSTORE_TYPE = "BCFKS";
    public static final String NONFIPS_KEYSTORE_TYPE = "PKCS12";
    public static final String FIPS_SSL_PROVIDER = "BCJSSE";
    public static final String FIPS_PROVIDER = "BCFIPS";
    public static final String PEM_TYPE = "PEM";
    private static final Logger log = LoggerFactory.getLogger(SslFactoryPemHelper.class);

    public static boolean isPemSecurityStore(String keyStoreType) {
        return Objects.equals(PEM_TYPE, keyStoreType);
    }

    public static KeyStore getKeyStoreFromPem(String keyStorePath, String keyStoreType, Password keyPassword, String provider, boolean isKeyStore) {
        if (Objects.equals(FIPS_SSL_PROVIDER, provider) && !Objects.equals(PEM_TYPE, keyStoreType)) {
            throw new RuntimeException(String.format("Only %s security store supported with %s ssl provider", PEM_TYPE, FIPS_SSL_PROVIDER));
        }
        if (keyPassword.value().equals("")) {
            keyPassword = null;
        }
        FileBasedPemStore store = new FileBasedPemStore(keyStorePath, keyPassword, isKeyStore, SslFactoryPemHelper.useBcfks(provider));
        return store.get();
    }

    private static boolean useBcfks(String provider) {
        return Objects.equals(FIPS_SSL_PROVIDER, provider);
    }

    public static String getKeyStoreType(String provider) {
        return SslFactoryPemHelper.useBcfks(provider) ? FIPS_KEYSTORE_TYPE : NONFIPS_KEYSTORE_TYPE;
    }

    public static class FileBasedPemStore
    extends FileBasedStore {
        public FileBasedPemStore(String path, Password keyPassword, boolean isKeyStore, boolean useBcfks) {
            super(SslFactoryPemHelper.PEM_TYPE, path, null, keyPassword, isKeyStore, useBcfks);
        }

        @Override
        protected KeyStore load(boolean isKeyStore) {
            try {
                Password storeContents = new Password(Utils.readFileAsString((String)this.path));
                PemStore pemStore = isKeyStore ? new PemStore(storeContents, storeContents, this.keyPassword, this.useBcfks) : new PemStore(storeContents, this.useBcfks);
                return pemStore.keyStore;
            }
            catch (Exception e) {
                log.error("Failed to load store, isKeyStore : {}, path {}", new Object[]{isKeyStore, this.path, e});
                throw new InvalidConfigurationException("Failed to load PEM SSL keystore " + this.path, (Throwable)e);
            }
        }
    }

    private static class SecurityFactory {
        private SecurityFactory() {
        }

        public static KeyStore getKeyStoreInstance(String type, boolean isFips) throws KeyStoreException, NoSuchProviderException {
            return isFips ? KeyStore.getInstance(type, SslFactoryPemHelper.FIPS_PROVIDER) : KeyStore.getInstance(type);
        }

        public static KeyStore getKeyStoreInstance(boolean isFips) throws KeyStoreException, NoSuchProviderException {
            String type = isFips ? SslFactoryPemHelper.FIPS_KEYSTORE_TYPE : SslFactoryPemHelper.NONFIPS_KEYSTORE_TYPE;
            return SecurityFactory.getKeyStoreInstance(type, isFips);
        }

        public static CertificateFactory getCertificateFactoryInstance(String type, boolean isFips) throws CertificateException, NoSuchProviderException {
            return isFips ? CertificateFactory.getInstance(type, SslFactoryPemHelper.FIPS_PROVIDER) : CertificateFactory.getInstance(type);
        }

        public static SecretKeyFactory getSecretKeyFactoryInstance(String algorithm, boolean isFips) throws NoSuchAlgorithmException, NoSuchProviderException {
            return isFips ? SecretKeyFactory.getInstance(algorithm, SslFactoryPemHelper.FIPS_PROVIDER) : SecretKeyFactory.getInstance(algorithm);
        }

        public static Cipher getCipherInstance(String algorithm, boolean isFips) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
            return isFips ? Cipher.getInstance(algorithm, SslFactoryPemHelper.FIPS_PROVIDER) : Cipher.getInstance(algorithm);
        }

        public static KeyFactory getKeyFactoryInstance(String algorithm, boolean isFips) throws NoSuchAlgorithmException, NoSuchProviderException {
            return isFips ? KeyFactory.getInstance(algorithm, SslFactoryPemHelper.FIPS_PROVIDER) : KeyFactory.getInstance(algorithm);
        }
    }

    static class PemParser {
        private final String name;
        private final Pattern pattern;

        PemParser(String name) {
            this.name = name;
            String beginOrEndFormat = "-+%s\\s*.*%s[^-]*-+\\s+";
            String nameIgnoreSpace = name.replace(" ", "\\s+");
            String encodingParams = "\\s*[^\\r\\n]*:[^\\r\\n]*[\\r\\n]+";
            String base64Pattern = "([a-zA-Z0-9/+=\\s]*)";
            String patternStr = String.format(beginOrEndFormat, "BEGIN", nameIgnoreSpace) + String.format("(?:%s)*", encodingParams) + base64Pattern + String.format(beginOrEndFormat, "END", nameIgnoreSpace);
            this.pattern = Pattern.compile(patternStr);
        }

        private List<byte[]> pemEntries(String pem) {
            Matcher matcher = this.pattern.matcher(pem + "\n");
            ArrayList<byte[]> entries = new ArrayList<byte[]>();
            while (matcher.find()) {
                String base64Str = matcher.group(1).replaceAll("\\s", "");
                entries.add(Base64.getDecoder().decode(base64Str));
            }
            if (entries.isEmpty()) {
                throw new InvalidConfigurationException("No matching " + this.name + " entries in PEM file");
            }
            return entries;
        }
    }

    public static class PemStore
    implements SecurityStore {
        private static final PemParser CERTIFICATE_PARSER = new PemParser("CERTIFICATE");
        private static final PemParser PRIVATE_KEY_PARSER = new PemParser("PRIVATE KEY");
        private final List<KeyFactory> keyFactories = Arrays.asList(this.keyFactory("RSA"), this.keyFactory("DSA"), this.keyFactory("EC"));
        private final char[] keyPassword;
        private final KeyStore keyStore;
        private final boolean useBcfks;

        public PemStore(Password certificateChain, Password privateKey, Password keyPassword, boolean useBcfks) {
            this.keyPassword = keyPassword == null ? null : keyPassword.value().toCharArray();
            this.useBcfks = useBcfks;
            this.keyStore = this.createKeyStoreFromPem(privateKey.value(), certificateChain.value(), this.keyPassword);
        }

        public PemStore(Password trustStoreCerts, boolean useBcfks) {
            this.keyPassword = null;
            this.useBcfks = useBcfks;
            this.keyStore = this.createTrustStoreFromPem(trustStoreCerts.value());
        }

        @Override
        public KeyStore get() {
            return this.keyStore;
        }

        @Override
        public char[] keyPassword() {
            return this.keyPassword;
        }

        @Override
        public boolean modified() {
            return false;
        }

        private KeyStore createKeyStoreFromPem(String privateKeyPem, String certChainPem, char[] keyPassword) {
            try {
                KeyStore ks = SecurityFactory.getKeyStoreInstance(this.useBcfks);
                ks.load(null, null);
                PrivateKey key = this.privateKey(privateKeyPem, keyPassword);
                Certificate[] certChain = this.certs(certChainPem);
                ks.setKeyEntry("kafka", key, keyPassword, certChain);
                return ks;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid PEM keystore configs", (Throwable)e);
            }
        }

        private KeyStore createTrustStoreFromPem(String trustedCertsPem) {
            try {
                KeyStore ts = SecurityFactory.getKeyStoreInstance(this.useBcfks);
                ts.load(null, null);
                Certificate[] certs = this.certs(trustedCertsPem);
                for (int i = 0; i < certs.length; ++i) {
                    ts.setCertificateEntry("kafka" + i, certs[i]);
                }
                return ts;
            }
            catch (InvalidConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Invalid PEM truststore configs", (Throwable)e);
            }
        }

        private Certificate[] certs(String pem) throws GeneralSecurityException {
            List<byte[]> certEntries = CERTIFICATE_PARSER.pemEntries(pem);
            if (certEntries.isEmpty()) {
                throw new InvalidConfigurationException("At least one certificate expected, but none found");
            }
            Certificate[] certs = new Certificate[certEntries.size()];
            for (int i = 0; i < certs.length; ++i) {
                CertificateFactory certificateFactory = SecurityFactory.getCertificateFactoryInstance("X.509", this.useBcfks);
                certs[i] = certificateFactory.generateCertificate(new ByteArrayInputStream(certEntries.get(i)));
            }
            return certs;
        }

        private PrivateKey privateKey(String pem, char[] keyPassword) throws Exception {
            PKCS8EncodedKeySpec keySpec;
            List<byte[]> keyEntries = PRIVATE_KEY_PARSER.pemEntries(pem);
            if (keyEntries.isEmpty()) {
                throw new InvalidConfigurationException("Private key not provided");
            }
            if (keyEntries.size() != 1) {
                throw new InvalidConfigurationException("Expected one private key, but found " + keyEntries.size());
            }
            byte[] keyBytes = keyEntries.get(0);
            if (keyPassword == null) {
                keySpec = new PKCS8EncodedKeySpec(keyBytes);
            } else {
                EncryptedPrivateKeyInfo keyInfo = new EncryptedPrivateKeyInfo(keyBytes);
                String algorithm = keyInfo.getAlgName();
                SecretKeyFactory keyFactory = SecurityFactory.getSecretKeyFactoryInstance(algorithm, this.useBcfks);
                SecretKey pbeKey = keyFactory.generateSecret(new PBEKeySpec(keyPassword));
                Cipher cipher = SecurityFactory.getCipherInstance(algorithm, this.useBcfks);
                cipher.init(2, (Key)pbeKey, keyInfo.getAlgParameters());
                keySpec = keyInfo.getKeySpec(cipher);
            }
            InvalidKeySpecException firstException = null;
            for (KeyFactory factory : this.keyFactories) {
                try {
                    return factory.generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            throw new InvalidConfigurationException("Private key could not be loaded", firstException);
        }

        private KeyFactory keyFactory(String algorithm) {
            try {
                return SecurityFactory.getKeyFactoryInstance(algorithm, this.useBcfks);
            }
            catch (Exception e) {
                throw new InvalidConfigurationException("Could not create key factory for algorithm " + algorithm, (Throwable)e);
            }
        }
    }

    static class FileBasedStore
    implements SecurityStore {
        private final String type;
        protected final String path;
        private final Password password;
        protected final Password keyPassword;
        private Long fileLastModifiedMs;
        private KeyStore keyStore;
        protected final boolean useBcfks;

        FileBasedStore(String type, String path, Password password, Password keyPassword, boolean isKeyStore, boolean useBcfks) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            this.path = path;
            this.password = password;
            this.keyPassword = keyPassword;
            this.useBcfks = useBcfks;
            this.reloadStore(isKeyStore);
        }

        public void reloadStore(boolean isKeyStore) {
            this.fileLastModifiedMs = this.lastModifiedMs(this.path);
            this.keyStore = this.load(isKeyStore);
        }

        @Override
        public KeyStore get() {
            return this.keyStore;
        }

        @Override
        public char[] keyPassword() {
            Password passwd = this.keyPassword != null ? this.keyPassword : this.password;
            return passwd == null ? null : passwd.value().toCharArray();
        }

        protected KeyStore load(boolean isKeyStore) {
            KeyStore keyStore;
            block8: {
                InputStream in = Files.newInputStream(Paths.get(this.path, new String[0]), new OpenOption[0]);
                try {
                    KeyStore ks = SecurityFactory.getKeyStoreInstance(this.type, this.useBcfks);
                    char[] passwordChars = this.password != null ? this.password.value().toCharArray() : null;
                    ks.load(in, passwordChars);
                    keyStore = ks;
                    if (in == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | GeneralSecurityException e) {
                        throw new KafkaException("Failed to load SSL keystore " + this.path + " of type " + this.type, (Throwable)e);
                    }
                }
                in.close();
            }
            return keyStore;
        }

        private Long lastModifiedMs(String path) {
            try {
                return Files.getLastModifiedTime(Paths.get(path, new String[0]), new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                log.error("Modification time of key store could not be obtained: " + path, (Throwable)e);
                return null;
            }
        }

        @Override
        public boolean modified() {
            Long modifiedMs = this.lastModifiedMs(this.path);
            return modifiedMs != null && !Objects.equals(modifiedMs, this.fileLastModifiedMs);
        }

        public String toString() {
            return "SecurityStore(path=" + this.path + ", modificationTime=" + String.valueOf(this.fileLastModifiedMs == null ? null : new Date(this.fileLastModifiedMs)) + ")";
        }
    }

    static interface SecurityStore {
        public KeyStore get();

        public char[] keyPassword();

        public boolean modified();
    }
}

