/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.customizer;

import io.confluent.rest.customizer.TlvProvider;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;

public class ProxyCustomizer
implements HttpConfiguration.Customizer {
    public static final String REMOTE_ADDRESS_ATTRIBUTE_NAME = "io.confluent.rest.proxy.remote.address";
    public static final String REMOTE_PORT_ATTRIBUTE_NAME = "io.confluent.rest.proxy.remote.port";
    public static final String LOCAL_ADDRESS_ATTRIBUTE_NAME = "io.confluent.rest.proxy.local.address";
    public static final String LOCAL_PORT_ATTRIBUTE_NAME = "io.confluent.rest.proxy.local.port";
    public static final String TLV_PROVIDER_ATTRIBUTE_NAME = "io.confluent.rest.proxy.tlv.provider";

    public Request customize(Request request, HttpFields.Mutable mutable) {
        EndPoint endPoint = request.getConnectionMetaData().getConnection().getEndPoint();
        if (endPoint instanceof SslConnection.SslEndPoint) {
            endPoint = ((SslConnection.SslEndPoint)endPoint).unwrap();
        }
        if (endPoint instanceof ProxyConnectionFactory.ProxyEndPoint) {
            ProxyConnectionFactory.ProxyEndPoint proxyEndPoint = (ProxyConnectionFactory.ProxyEndPoint)endPoint;
            EndPoint underlyingEndpoint = proxyEndPoint.unwrap();
            request = new ProxyRequest((Request)request, underlyingEndpoint.getLocalSocketAddress(), underlyingEndpoint.getRemoteSocketAddress(), arg_0 -> ((ProxyConnectionFactory.ProxyEndPoint)proxyEndPoint).getTLV(arg_0));
        }
        return request;
    }

    private static class ProxyRequest
    extends Request.Wrapper {
        private final String remoteAddress;
        private final String localAddress;
        private final int remotePort;
        private final int localPort;
        private final TlvProvider tlvProvider;

        private ProxyRequest(Request request, SocketAddress local, SocketAddress remote, TlvProvider tlvProvider) {
            super(request);
            InetSocketAddress inetLocal = local instanceof InetSocketAddress ? (InetSocketAddress)local : null;
            InetSocketAddress inetRemote = remote instanceof InetSocketAddress ? (InetSocketAddress)remote : null;
            this.localAddress = inetLocal == null ? null : inetLocal.getAddress().getHostAddress();
            this.remoteAddress = inetRemote == null ? null : inetRemote.getAddress().getHostAddress();
            this.localPort = inetLocal == null ? 0 : inetLocal.getPort();
            this.remotePort = inetRemote == null ? 0 : inetRemote.getPort();
            this.tlvProvider = tlvProvider;
        }

        public Object getAttribute(String name) {
            return switch (name) {
                case ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME -> this.remoteAddress;
                case ProxyCustomizer.REMOTE_PORT_ATTRIBUTE_NAME -> this.remotePort;
                case ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME -> this.localAddress;
                case ProxyCustomizer.LOCAL_PORT_ATTRIBUTE_NAME -> this.localPort;
                case ProxyCustomizer.TLV_PROVIDER_ATTRIBUTE_NAME -> this.tlvProvider;
                default -> super.getAttribute(name);
            };
        }

        public Set<String> getAttributeNameSet() {
            HashSet<String> names = new HashSet<String>(super.getAttributeNameSet());
            names.remove(ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME);
            names.remove(ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME);
            if (this.remoteAddress != null) {
                names.add(ProxyCustomizer.REMOTE_ADDRESS_ATTRIBUTE_NAME);
            }
            if (this.localAddress != null) {
                names.add(ProxyCustomizer.LOCAL_ADDRESS_ATTRIBUTE_NAME);
            }
            names.add(ProxyCustomizer.REMOTE_PORT_ATTRIBUTE_NAME);
            names.add(ProxyCustomizer.LOCAL_PORT_ATTRIBUTE_NAME);
            names.add(ProxyCustomizer.TLV_PROVIDER_ATTRIBUTE_NAME);
            return names;
        }
    }
}

