/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.ratelimit;

import io.confluent.rest.RestConfig;
import io.confluent.rest.ratelimit.NetworkTrafficRateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiter;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import java.time.Duration;

public final class NetworkTrafficRateLimiterFactory {
    private NetworkTrafficRateLimiterFactory() {
    }

    public static NetworkTrafficRateLimiter create(RestConfig restConfig) {
        int bytesPerSecond = restConfig.getNetworkTrafficRateLimitBytesPerSec();
        switch (restConfig.getNetworkTrafficRateLimitBackend()) {
            case GUAVA: {
                return GuavaNetworkTrafficRateLimiter.create(bytesPerSecond);
            }
            case RESILIENCE4J: {
                return Resilience4JNetworkTrafficRateLimiter.create(bytesPerSecond);
            }
        }
        throw new AssertionError((Object)("Unknown enum constant: " + String.valueOf((Object)restConfig.getNetworkTrafficRateLimitBackend())));
    }

    static final class GuavaNetworkTrafficRateLimiter
    implements NetworkTrafficRateLimiter {
        private final com.google.common.util.concurrent.RateLimiter delegate;

        GuavaNetworkTrafficRateLimiter(com.google.common.util.concurrent.RateLimiter delegate) {
            this.delegate = delegate;
        }

        static GuavaNetworkTrafficRateLimiter create(int bytesPerSecond) {
            return new GuavaNetworkTrafficRateLimiter(com.google.common.util.concurrent.RateLimiter.create((double)bytesPerSecond));
        }

        @Override
        public void rateLimit(int cost) {
            this.delegate.acquire(cost);
        }
    }

    static final class Resilience4JNetworkTrafficRateLimiter
    implements NetworkTrafficRateLimiter {
        private final RateLimiter delegate;

        Resilience4JNetworkTrafficRateLimiter(RateLimiter delegate) {
            this.delegate = delegate;
        }

        static Resilience4JNetworkTrafficRateLimiter create(int bytesPerSecond) {
            RateLimiterConfig config = RateLimiterConfig.custom().limitRefreshPeriod(Duration.ofSeconds(1L)).limitForPeriod(bytesPerSecond).build();
            return new Resilience4JNetworkTrafficRateLimiter(RateLimiter.of((String)"Resilience4JNetworkTrafficRateLimiter", (RateLimiterConfig)config));
        }

        @Override
        public void rateLimit(int cost) {
            this.delegate.acquirePermission(cost);
        }
    }
}

