/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication;

import io.confluent.security.authentication.AuthenticationException;
import io.confluent.security.authentication.Authenticator;
import io.confluent.security.authentication.credential.BearerCredential;
import io.confluent.security.authentication.oauthbearer.Claims;
import io.confluent.security.authentication.oauthbearer.JwtAuthenticator;
import io.confluent.security.policyapi.engine.PolicyEngine;
import io.confluent.security.trustservice.store.TrustCache;
import io.confluent.security.trustservice.store.data.IdentityPool;
import java.util.Map;
import java.util.function.Supplier;

public class AdmissionController {
    public static final String OAUTH_AUTHORIZED_PARTY = "azp";
    private final Authenticator<?, ?> authenticator;
    private final Supplier<TrustCache> trustCacheSupplier;
    private final PolicyEngine<String> policyEngine;

    public AdmissionController(Authenticator<?, ?> authenticator, Supplier<TrustCache> trustCacheSupplier, PolicyEngine<String> policyEngine) {
        this.authenticator = authenticator;
        this.trustCacheSupplier = trustCacheSupplier;
        this.policyEngine = policyEngine;
    }

    public Claims authenticate(BearerCredential credential) throws AuthenticationException {
        if (this.authenticator instanceof JwtAuthenticator) {
            return ((JwtAuthenticator)this.authenticator).authenticate(credential);
        }
        throw new AuthenticationException("Unable to process credential");
    }

    public Map<String, Object> assumePrincipal(Map<String, Object> claims, String poolId) throws AuthenticationException, IllegalArgumentException {
        IdentityPool identityPool = this.trustCacheSupplier.get().identityPool(poolId);
        if (identityPool == null) {
            throw new AuthenticationException(String.format("Unknown Identity Pool %s.", poolId));
        }
        if (!AdmissionController.validateIssuer(claims, identityPool.issuer())) {
            throw new AuthenticationException(String.format("Provided claim issuer %s do not match Identity Pool %s Trust Policy issuer %s.", AdmissionController.claimValue(claims, "iss", String.class), poolId, identityPool.issuer()));
        }
        if (!this.policyEngine.evaluatePolicy(identityPool.policy(), claims)) {
            throw new AuthenticationException(String.format("Provided claims do not match Identity Pool %s Trust Policy.", poolId));
        }
        claims.put(OAUTH_AUTHORIZED_PARTY, identityPool.subjectClaim());
        claims.put("sub", identityPool.serviceAccount());
        return claims;
    }

    private static boolean validateIssuer(Map<String, Object> claims, String issuer) {
        return issuer.equals(AdmissionController.claimValue(claims, "iss", String.class));
    }

    private static <T> T claimValue(Map<String, Object> claims, String claim, Class<T> valueType) {
        try {
            return valueType.cast(claims.get(claim));
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Failed to read claim", t);
        }
    }
}

