/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import io.confluent.security.authentication.oauthbearer.JwtPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public final class CloudJwtPrincipal
extends JwtPrincipal {
    public static final String CLAIM_CLUSTERS = "clusters";
    public static final String CLAIM_ORGANIZATION_ID = "organizationId";
    public static final String CLAIM_USER_ID = "userId";
    public static final String CLAIM_USER_RESOURCE_ID = "userResourceId";
    private final List<String> clusters;
    private final Long organizationId;
    private final Long userId;
    private final String userResourceId;

    public CloudJwtPrincipal(JwtClaims claims) throws MalformedClaimException {
        super(claims);
        this.clusters = claims.getStringListClaimValue(CLAIM_CLUSTERS);
        this.organizationId = Optional.ofNullable(claims.getClaimValue(CLAIM_ORGANIZATION_ID)).map(Long.class::cast).orElse(null);
        this.userId = Optional.ofNullable(claims.getClaimValue(CLAIM_USER_ID)).map(Long.class::cast).orElse(null);
        this.userResourceId = Optional.ofNullable(claims.getClaimValue(CLAIM_USER_RESOURCE_ID)).map(String.class::cast).orElse(null);
    }

    public List<String> clusters() {
        return Collections.unmodifiableList(new ArrayList<String>(this.clusters));
    }

    public Long organizationId() {
        return this.organizationId;
    }

    public Long userId() {
        return this.userId;
    }

    public String userResourceId() {
        return this.userResourceId;
    }
}

