/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oidc;

import io.confluent.security.authentication.oidc.TokenResponse;
import java.util.Calendar;

public class CachedGrant {
    private static final float CACHE_PERCENTAGE_THRESHOLD = 0.8f;
    private final String accessToken;
    private final String tokenType;
    private final String refreshToken;
    private final long lifespanSeconds;
    private final String idToken;
    private final String scope;
    private final Calendar calendar;
    private final long expiresAtMs;

    private CachedGrant(String accessToken, String tokenType, String refreshToken, long lifespanSeconds, String idToken, String scope, Calendar calendar) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.refreshToken = refreshToken;
        this.lifespanSeconds = lifespanSeconds;
        this.idToken = idToken;
        this.scope = scope;
        this.calendar = calendar;
        this.expiresAtMs = (long)Math.floor((float)lifespanSeconds * 0.8f * 1000.0f) + calendar.getTimeInMillis();
    }

    public static CachedGrant fromTokenResponse(TokenResponse response, Calendar calendar) {
        return new CachedGrant(response.getAccessToken(), response.getTokenType(), response.getRefreshToken(), response.getExpiresIn(), response.getIdToken(), response.getScope(), calendar);
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public long getExpiresAtMs() {
        return this.expiresAtMs;
    }

    public long getLifespanSeconds() {
        return this.lifespanSeconds;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isExpired() {
        return this.calendar.getTimeInMillis() >= this.expiresAtMs;
    }
}

