/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.security.policyapi.ConfluentPolicy;
import io.confluent.security.policyapi.exception.PolicyEngineException;
import io.confluent.security.policyapi.rules.Rule;
import io.confluent.security.policyapi.rules.RuleBuilder;
import java.util.Objects;

public final class PolicyRuleLoadingCache<T> {
    public static final long CAPACITY_DEFAULT = 1000L;
    private final LoadingCache<ConfluentPolicy<T>, Rule> cache;

    public PolicyRuleLoadingCache(RuleBuilder<T> ruleBuilder) {
        this(1000L, ruleBuilder);
    }

    public PolicyRuleLoadingCache(long capacity, RuleBuilder<T> ruleBuilder) {
        this.cache = this.buildCache(capacity, ruleBuilder);
    }

    public Rule get(ConfluentPolicy<T> policy) {
        try {
            return (Rule)this.cache.get(Objects.requireNonNull(policy));
        }
        catch (Throwable t) {
            throw new PolicyEngineException(String.format("Unable to process request for policy %s", policy), t);
        }
    }

    private LoadingCache<ConfluentPolicy<T>, Rule> buildCache(long capacity, final RuleBuilder<T> ruleBuilder) {
        CacheLoader cacheLoader = new CacheLoader<ConfluentPolicy<T>, Rule>(){

            public Rule load(ConfluentPolicy<T> policy) {
                try {
                    return ruleBuilder.read(policy.condition());
                }
                catch (Throwable t) {
                    throw new PolicyEngineException(String.format("Failed to load policy %s", policy), t);
                }
            }
        };
        return CacheBuilder.newBuilder().maximumSize(capacity).build(cacheLoader);
    }
}

