/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast;

import io.confluent.security.config.AbstractConfiguration;
import io.confluent.security.config.Validation;
import io.confluent.security.policyapi.ast.AstBuilder;

public class AstBuilderConfig
extends AbstractConfiguration<AstBuilder> {
    public static final int ARRAY_LIST_LIMIT_DEFAULT = 256;
    private static final int ARRAY_LIST_LIMIT_MIN = 16;
    private static final int ARRAY_LIST_LIMIT_MAX = 1024;
    public static final int CHAIN_LIMIT_DEFAULT = 32;
    private static final int CHAIN_LIMIT_MIN = 16;
    private static final int CHAIN_LIMIT_MAX = 128;
    public static final int PARAMETER_LIST_LIMIT_DEFAULT = 32;
    private static final int PARAMETER_LIST_LIMIT_MIN = 16;
    private static final int PARAMETER_LIST_LIMIT_MAX = 128;
    public static final int NESTING_LIMIT_DEFAULT = 32;
    private static final int NESTING_LIMIT_MIN = 16;
    private static final int NESTING_LIMIT_MAX = 128;
    private final int arrayListLimit;
    private final int chainLimit;
    private final int parameterListLimit;
    private final int nestingLimit;

    private AstBuilderConfig(int arrayListLimit, int chainLimit, int parameterListLimit, int nestingLimit) {
        this.arrayListLimit = arrayListLimit;
        this.chainLimit = chainLimit;
        this.parameterListLimit = parameterListLimit;
        this.nestingLimit = nestingLimit;
    }

    @Override
    public AstBuilder create() {
        return new AstBuilder(this.arrayListLimit, this.chainLimit, this.parameterListLimit, this.nestingLimit);
    }

    public static AstBuilder defaultAstBuilder() {
        return new AstBuilder(256, 32, 32, 32);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int arrayListLimit = 256;
        private int chainLimit = 32;
        private int parameterListLimit = 32;
        private int nestingLimit = 32;

        private Builder() {
        }

        public Builder arrayListLimit(int arrayListLimit) {
            this.arrayListLimit = Validation.isBetween(16, 1024, arrayListLimit);
            return this;
        }

        public Builder chainLimit(int chainLimit) {
            this.chainLimit = Validation.isBetween(16, 128, chainLimit);
            return this;
        }

        public Builder parameterListLimit(int parameterListLimit) {
            this.parameterListLimit = Validation.isBetween(16, 128, parameterListLimit);
            return this;
        }

        public Builder nestingLimit(int nestingLimit) {
            this.nestingLimit = Validation.isBetween(16, 128, nestingLimit);
            return this;
        }

        public AstBuilderConfig build() {
            return new AstBuilderConfig(this.arrayListLimit, this.chainLimit, this.parameterListLimit, this.nestingLimit);
        }
    }
}

