/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast;

import io.confluent.security.policyapi.ast.AbstractSyntaxTreeNode;
import io.confluent.security.policyapi.ast.EqualsNode;
import io.confluent.security.policyapi.ast.ExpressionNode;
import io.confluent.security.policyapi.ast.FunctionCallNode;
import io.confluent.security.policyapi.ast.ListNode;
import io.confluent.security.policyapi.ast.LogicalAndNode;
import io.confluent.security.policyapi.ast.LogicalNotNode;
import io.confluent.security.policyapi.ast.LogicalOrNode;
import io.confluent.security.policyapi.ast.StringLiteralNode;
import io.confluent.security.policyapi.ast.VariableNode;
import io.confluent.security.policyapi.ast.Visitor;

public class BaseVisitor<T>
implements Visitor<T> {
    @Override
    public T visit(AbstractSyntaxTreeNode node) {
        return node.accept(this);
    }

    @Override
    public T visitExpressionNode(ExpressionNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitEqualsNode(EqualsNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitFunctionCallNode(FunctionCallNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitListNode(ListNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitLogicalAndNode(LogicalAndNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitLogicalNotNode(LogicalNotNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitLogicalOrNode(LogicalOrNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitStringLiteralNode(StringLiteralNode node) {
        return this.visitChildren(node);
    }

    @Override
    public T visitVariableNode(VariableNode node) {
        return this.visitChildren(node);
    }

    protected T aggregateResult(T prev, T current) {
        return current;
    }

    protected T defaultResult() {
        return null;
    }

    protected T visitChildren(AbstractSyntaxTreeNode node) {
        T result = this.defaultResult();
        for (AbstractSyntaxTreeNode child : node.getChildren()) {
            Object current = child.accept(this);
            result = this.aggregateResult(result, current);
        }
        return result;
    }
}

