/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.ast.checker;

import io.confluent.security.policyapi.PolicyRuleBaseVisitor;
import io.confluent.security.policyapi.PolicyRuleParser;
import io.confluent.security.policyapi.exception.RuleBuilderException;
import java.util.Stack;
import org.antlr.v4.runtime.tree.RuleNode;

public final class ChainLevelVisitor
extends PolicyRuleBaseVisitor<Void> {
    private final Stack<Integer> expressionChains = new Stack();
    private final int limit;

    private void incrementChainingLevel() {
        int current = this.expressionChains.pop();
        if (current + 1 >= this.limit) {
            throw new RuleBuilderException("Chain limit exceeded");
        }
        this.expressionChains.push(current + 1);
    }

    public ChainLevelVisitor(int limit) {
        this.limit = limit;
        this.expressionChains.push(0);
    }

    @Override
    public Void visitExpressionNestedExpr(PolicyRuleParser.ExpressionNestedExprContext ctx) {
        this.expressionChains.push(0);
        super.visitChildren((RuleNode)ctx);
        this.expressionChains.pop();
        return null;
    }

    @Override
    public Void visitExpressionLogicalAndExpr(PolicyRuleParser.ExpressionLogicalAndExprContext ctx) {
        assert (ctx.expression().size() == 2);
        this.incrementChainingLevel();
        super.visitChildren((RuleNode)ctx);
        return null;
    }

    @Override
    public Void visitExpressionLogicalOrExpr(PolicyRuleParser.ExpressionLogicalOrExprContext ctx) {
        assert (ctx.expression().size() == 2);
        this.incrementChainingLevel();
        super.visitChildren((RuleNode)ctx);
        return null;
    }
}

