/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.engine;

import io.confluent.security.policyapi.ConfluentPolicy;
import io.confluent.security.policyapi.PolicyRuleLoadingCache;
import io.confluent.security.policyapi.engine.PolicyEngine;
import io.confluent.security.policyapi.exception.PolicyEngineException;
import io.confluent.security.policyapi.rules.Rule;
import io.confluent.security.policyapi.rules.RuleBuilder;
import io.confluent.security.policyapi.rules.TrustPolicyRuleBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustPolicyEngine
implements PolicyEngine<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustPolicyEngine.class);
    public static final String CLAIM_PREFIX = "claims";
    private final PolicyRuleLoadingCache<String> cache;
    private final RuleBuilder<String> ruleBuilder;

    public TrustPolicyEngine() {
        this(null, null);
    }

    public TrustPolicyEngine(PolicyRuleLoadingCache<String> cache) {
        this(null, cache);
    }

    public TrustPolicyEngine(TrustPolicyRuleBuilder ruleBuilder, PolicyRuleLoadingCache<String> cache) {
        this.ruleBuilder = ruleBuilder == null ? new TrustPolicyRuleBuilder() : ruleBuilder;
        this.cache = cache == null ? new PolicyRuleLoadingCache<String>(this.ruleBuilder) : cache;
    }

    @Override
    public boolean evaluatePolicy(ConfluentPolicy<String> policy, Map<String, Object> claims) throws PolicyEngineException {
        try {
            Rule rule = this.cache.get(Objects.requireNonNull(policy));
            return rule.evaluate(TrustPolicyEngine.remapClaims(claims));
        }
        catch (Throwable t) {
            throw new PolicyEngineException("Could not evaluate rule for workload identity " + policy, t);
        }
    }

    @Override
    public void validatePolicy(String statements) throws PolicyEngineException {
        try {
            this.ruleBuilder.read(statements);
        }
        catch (Exception e) {
            LOGGER.error("Could not compile statements {}: {}", (Object)statements, (Object)e);
            throw new PolicyEngineException(e);
        }
    }

    @Override
    public boolean validatePolicyEvaluation(String statements, Map<String, Object> claims) throws PolicyEngineException {
        try {
            Rule rule = this.ruleBuilder.read(statements);
            return rule.evaluate(TrustPolicyEngine.remapClaims(claims));
        }
        catch (Exception e) {
            LOGGER.error("Could not evaluate rule for expression {}: {}", (Object)statements, (Object)e);
            throw new PolicyEngineException(e);
        }
    }

    private static Map<String, Object> remapClaims(Map<String, Object> claims) {
        return claims.entrySet().stream().collect(Collectors.toMap(e -> "claims." + (String)e.getKey(), Map.Entry::getValue));
    }
}

