/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.policyapi.rules;

import io.confluent.security.policyapi.ast.ListNode;
import io.confluent.security.policyapi.ast.ParameterNode;
import io.confluent.security.policyapi.ast.StringLiteralNode;
import io.confluent.security.policyapi.exception.RuleBuilderException;
import io.confluent.security.policyapi.rules.Rule;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class RuleFunctionClaimInArray
implements Rule {
    private final String claim;
    private final Set<String> set;

    public RuleFunctionClaimInArray(String claim, ListNode<ParameterNode> list) {
        this.claim = claim;
        this.set = list.getList().stream().map(parameterNode -> {
            if (parameterNode instanceof StringLiteralNode) {
                return ((StringLiteralNode)parameterNode).getValue();
            }
            throw new RuleBuilderException("Invalid argument type: " + parameterNode.getClass().getName());
        }).collect(Collectors.toSet());
    }

    @Override
    public boolean evaluate(Map<String, Object> claims) {
        return this.set.contains(claims.get(this.claim));
    }
}

